/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.neptune.realm.persist.ExternalUser;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.usermgmt.ejb.UserManager;
import com.tandbergtv.neptune.usermgmt.external.IExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.service.UserSynchronizationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

class UserSynchronizer {
    private static final Logger logger = Logger.getLogger((String)UserSynchronizer.class.getName());
    private long DEFAULT_SYNCHRONIZATION_TIMEOUT = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
    private final UserManager userManager;

    UserSynchronizer(UserManager userManager) {
        this.userManager = userManager;
    }

    List<User> trySynchronize(List<User> users) {
        if (users == null) {
            return users;
        }
        if (!this.isExternalMode()) {
            return users;
        }
        ArrayList<User> synchronizedUsers = new ArrayList<User>(users.size());
        for (User user : users) {
            User synchronizedUser = this.trySynchronize(user);
            synchronizedUsers.add(synchronizedUser);
        }
        return synchronizedUsers;
    }

    User trySynchronize(User user) {
        if (user == null) {
            return user;
        }
        if (this.isSynchronizationRequired(user)) {
            try {
                user = this.synchronize(user);
            }
            catch (UserSynchronizationException e) {
                String msg = "Failure synchronizing user" + user + " with external system, using last saved user data instead.";
                logger.warn((Object)msg, (Throwable)e);
            }
        }
        return user;
    }

    User synchronize(User user) {
        if (user == null) {
            return user;
        }
        if (!this.isExternalMode()) {
            UserConfigurationMode mode = this.userManager.getUserConfigurationMode();
            String msg = "Cannot perform synchronization for '" + mode + "' configuration mode, " + "mode must be '" + UserConfigurationMode.External + "'";
            throw new UserSynchronizationException(msg);
        }
        String externalKey = user.getExternalKey();
        if (externalKey == null) {
            String msg = "User" + user + " does not have an external key.";
            throw new UserSynchronizationException(msg);
        }
        try {
            IExternalUserProvider provider = this.getExternalUserProvider();
            ExternalUser externalUser = provider.getUser(externalKey);
            if (externalUser != null) {
                user.setUserName(externalUser.getUserName());
                user.setDepartment(externalUser.getDepartment());
                user.setEmail(externalUser.getEmail());
                user.setEmployeeId(externalUser.getEmployeeId());
                user.setExtension(externalUser.getExtension());
                user.setFirstName(externalUser.getFirstName());
                user.setLastName(externalUser.getLastName());
                user.setLocation(externalUser.getLocation());
                user.setPhone(externalUser.getPhone());
            }
            user.setActive(externalUser != null);
            user.setPassword(null);
            user.setExternallyAuthenticated(true);
            user.setSyncDate(new Date());
        }
        catch (RuntimeException e) {
            throw new UserSynchronizationException("Error getting external user[" + externalKey + "] '" + user.getUserName() + "': " + e.getLocalizedMessage(), (Throwable)e);
        }
        return user;
    }

    private boolean isSynchronizationRequired(User user) {
        long syncTime;
        long currentTime;
        long timeDifference;
        if (!this.isExternalMode()) {
            return false;
        }
        if (user.getExternalKey() == null) {
            return false;
        }
        long synchronizationTimeout = this.getSynchronizationTimeout();
        if (synchronizationTimeout <= 0L) {
            return false;
        }
        boolean syncRequired = false;
        syncRequired = user.getSyncDate() == null ? true : (timeDifference = (currentTime = System.currentTimeMillis()) - (syncTime = user.getSyncDate().getTime())) < 0L || timeDifference >= synchronizationTimeout;
        return syncRequired;
    }

    private long getSynchronizationTimeout() {
        long timeout = 0L;
        try {
            timeout = this.getExternalUserProvider().getSynchronizationInterval();
            timeout = TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to get the user synchronization timeout period, using default value of 1 week.", t);
            timeout = this.DEFAULT_SYNCHRONIZATION_TIMEOUT;
        }
        return timeout;
    }

    private boolean isExternalMode() {
        return UserConfigurationMode.External.equals((Object)this.userManager.getUserConfigurationMode());
    }

    private IExternalUserProvider getExternalUserProvider() {
        UserConfigurationFactory factory = UserConfigurationFactory.getFactory();
        IExternalUserProvider provider = factory.createExternalUserProvider();
        if (provider == null) {
            String msg = "No instance of IExternalUserProvider was created by UserConfigurationFactory[" + factory.getClass().getName() + "]";
            throw new RuntimeException(msg);
        }
        return provider;
    }
}

