/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.ejb.Aggregator;
import com.ericsson.neptune.alerts.ejb.JobScheduler;
import com.ericsson.neptune.alerts.entity.Alert;
import com.ericsson.neptune.alerts.entity.AlertsSummary;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.alerts.service.IAlertAggregationService")
@Local(value={IAlertsAggregationService.class})
public class AlertsAggregationService
implements IAlertsAggregationService {
    private static final String ALERTS_LIST = "alertsList";
    private static final String ALERTS_LOCK = "alertsLock";
    private static final Logger logger = Logger.getLogger(AlertsAggregationService.class);
    int waitTime = 0;
    int pollInterval = 0;
    @EJB
    private ISettingsService settingsService;

    public void start() throws Exception {
        try {
            this.pollInterval = Integer.parseInt((String)this.settingsService.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("poll_interval"));
            this.waitTime = Integer.parseInt((String)this.settingsService.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("wait_time"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Unable to parse Aggregator pollInterval or waitTime setting.", (Throwable)e);
        }
        if (this.pollInterval == 0) {
            return;
        }
        JobScheduler scheduler = new JobScheduler(1);
        scheduler.schedule(new Aggregator(), this.waitTime, this.pollInterval);
        logger.info((Object)("Alert aggregation job scheduled every " + this.pollInterval / 1000 + " secs"));
    }

    public synchronized AlertsSummary getSummary() {
        long lStartTime = System.nanoTime();
        AlertsSummary sum = new AlertsSummary();
        List<Alert> alerts = this.getAlerts();
        if (alerts == null || alerts.isEmpty()) {
            return sum;
        }
        int errors = 0;
        int warnings = 0;
        int informationals = 0;
        for (Alert alert : alerts) {
            if (alert.getSeverity() == SeverityType.Error) {
                ++errors;
                continue;
            }
            if (alert.getSeverity() == SeverityType.Warning) {
                ++warnings;
                continue;
            }
            if (alert.getSeverity() != SeverityType.Informational) continue;
            ++informationals;
        }
        sum.setTotalErrors(Integer.valueOf(errors));
        sum.setTotalWarnings(Integer.valueOf(warnings));
        sum.setTotalInformationals(Integer.valueOf(informationals));
        long lEndTime = System.nanoTime();
        long difference = lEndTime - lStartTime;
        logger.info((Object)("Elapsed milliseconds in getSummary : " + difference / 1000000L));
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Alert> getAlerts() {
        ILock lock = Hazelcast.getLock((Object)ALERTS_LOCK);
        try {
            lock.lock();
            IList alerts = Hazelcast.getList((String)ALERTS_LIST);
            List<Alert> list = Collections.unmodifiableList(alerts);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAlerts(List<Alert> alerts) {
        ILock lock = Hazelcast.getLock((Object)ALERTS_LOCK);
        try {
            lock.lock();
            IList alertsList = Hazelcast.getList((String)ALERTS_LIST);
            alertsList.clear();
            alertsList.addAll(alerts);
        }
        finally {
            lock.unlock();
        }
    }
}

