/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.ejb.dao;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SettingsDefinitionDAO {
    private List<SettingGroup> settings = new ArrayList<SettingGroup>();
    private Map<String, SettingGroup> settingsMap = Collections.emptyMap();
    private Set<String> groupsWithErrors = new HashSet<String>();
    private static SettingsDefinitionDAO instance = new SettingsDefinitionDAO();

    private SettingsDefinitionDAO() {
    }

    public void saveSettingDefinitions(List<SettingGroup> newSettings) {
        this.settings.addAll(newSettings);
        this.sortSettings(this.settings);
        this.settingsMap = new HashMap<String, SettingGroup>(this.settings.size());
        for (SettingGroup group : this.settings) {
            this.settingsMap.put(group.getPath(), group);
        }
    }

    private void sortSettings(List<SettingGroup> settings) {
        Collections.sort(settings, new Comparator<SettingGroup>(){

            @Override
            public int compare(SettingGroup o1, SettingGroup o2) {
                String o1Name = "";
                String o2Name = "";
                if (o1.getDisplayName() != null && !o1.getDisplayName().isEmpty()) {
                    o1Name = ((LocalizedString)o1.getDisplayName().get(0)).getValue();
                }
                if (o2.getDisplayName() != null && !o2.getDisplayName().isEmpty()) {
                    o2Name = ((LocalizedString)o2.getDisplayName().get(0)).getValue();
                }
                return o1Name.compareToIgnoreCase(o2Name);
            }
        });
    }

    public List<SettingGroup> getAllSettingDefinitions() {
        return this.settings;
    }

    protected boolean find(String filter, List<LocalizedString> list) {
        for (LocalizedString ls : list) {
            if (!ls.getValue().toUpperCase().contains(filter)) continue;
            return true;
        }
        return false;
    }

    protected boolean find(String filter, SettingGroup group) {
        boolean matches = false;
        if (this.find(filter, group.getDisplayName())) {
            matches = true;
        } else {
            for (SettingDefinition def : group.getSettings()) {
                if (!this.find(filter, def)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    protected boolean find(String filter, SettingDefinition set) {
        boolean matches = false;
        if (set.getName().toUpperCase().contains(filter) || this.find(filter, set.getDisplayName()) || this.find(filter, set.getHelpText())) {
            matches = true;
        }
        return matches;
    }

    public List<SettingGroup> findSettingDefinitions(String filter) {
        List<SettingGroup> allSettings = this.getAllSettingDefinitions();
        filter = filter.toUpperCase();
        HashMap<String, SettingGroup> filteredMap = new HashMap<String, SettingGroup>();
        for (SettingGroup group : allSettings) {
            if (!this.find(filter, group)) continue;
            filteredMap.put(group.getPath(), group);
            if (group.getParentPath() == null) continue;
            this.addMissingParent(filteredMap, group.getParentPath());
        }
        ArrayList<SettingGroup> filteredSettings = new ArrayList<SettingGroup>(filteredMap.values());
        this.sortSettings(filteredSettings);
        return filteredSettings;
    }

    protected void addMissingParent(Map<String, SettingGroup> filteredMap, String parentPath) {
        SettingGroup parent = this.settingsMap.get(parentPath);
        if (parent != null) {
            filteredMap.put(parent.getPath(), parent);
            if (parent.getParentPath() != null) {
                this.addMissingParent(filteredMap, parent.getParentPath());
            }
        }
    }

    public SettingGroup getSettingDefinitionsForGroup(String path) {
        return this.settingsMap.get(path);
    }

    public void setGroupWithErrors(String path) {
        this.groupsWithErrors.add(path);
    }

    public Set<String> getGroupsWithErrors() {
        return this.groupsWithErrors;
    }

    public static SettingsDefinitionDAO getInstance() {
        return instance;
    }

    public void clearGroupErrors(String path) {
        this.groupsWithErrors.remove(path);
    }
}

