/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.ejb;

import com.ericsson.neptune.alerts.entity.Alert;
import com.tandbergtv.neptune.alerts.service.IAlertsAggregationService;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.settings.ejb.dao.SettingsDefinitionDAO;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;

public class Aggregator
implements Runnable {
    private static final String PROPERTIES_FILE = "conf/neptune/alerts.properties";
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final Logger logger = Logger.getLogger(Aggregator.class);
    private int responseTimeout = 10000;
    private String alertQueueName = "queue/AlertCmdQueue";
    IAlertsAggregationService alertsAggregationService = (IAlertsAggregationService)InjectionUtil.injectInstance((String)"cms/AlertsAggregationService/local", IAlertsAggregationService.class);
    ISettingsService configService = (ISettingsService)InjectionUtil.injectInstance((String)"cms/SettingsService/local", ISettingsService.class);

    @Override
    public void run() {
        this.pollAlertProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAlertProviders() {
        InitialContext context = null;
        QueueSession queueSession = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Message response;
            context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("java:/JmsXA");
            QueueConnection queueConnection = queueFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(true, 0);
            Queue queue = (Queue)context.lookup(this.alertQueueName);
            QueueSender queueSender = queueSession.createSender(queue);
            queueSender.setDeliveryMode(1);
            TemporaryQueue replyQueue = queueSession.createTemporaryQueue();
            for (SettingGroup g : SettingsDefinitionDAO.getInstance().findSettingDefinitionsByParentPath("com.ericsson.cms.neptune.alert.providers")) {
                logger.debug((Object)g.getPath());
                String duration_days = (String)this.configService.getProperties("com.ericsson.cms.neptune.alerts").get("time_window");
                Calendar cal = Calendar.getInstance();
                cal.add(5, -Integer.parseInt(duration_days));
                String start_time = dateFormat.format(cal.getTime());
                String url = "https://localhost:8443" + (String)this.configService.getProperties(g.getPath()).get("provider_url") + "?startTime=" + URLEncoder.encode(start_time, "UTF-8");
                ObjectMessage message = queueSession.createObjectMessage();
                message.setJMSReplyTo((Destination)replyQueue);
                message.setStringProperty("url", url);
                queueSender.send(queue, (Message)message);
            }
            queueConnection.start();
            MessageConsumer consumer = queueSession.createConsumer((Destination)replyQueue);
            ArrayList<Alert> allAlerts = new ArrayList<Alert>();
            while ((response = consumer.receive((long)this.responseTimeout)) != null) {
                TextMessage res = (TextMessage)response;
                logger.debug((Object)("Recv Json String from MDB:" + res.getText()));
                String jSonString = res.getText();
                if (jSonString == null || jSonString.isEmpty()) continue;
                List<Alert> componentAlertList = this.getAlertsFromJsonString(jSonString);
                logger.debug((Object)("List of Alerts: " + this.getAlertsFromJsonString(jSonString).toString()));
                allAlerts.addAll(componentAlertList);
            }
            logger.debug((Object)("Total # of alerts from polled alert providers: " + allAlerts.size()));
            this.alertsAggregationService.setAlerts(allAlerts);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending the event", (Throwable)e);
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close the JMS session and context", (Throwable)e);
            }
        }
    }

    private List<Alert> getAlertsFromJsonString(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Class<?> clz = Class.forName(Alert.class.getName());
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clz);
        List alerts = (List)mapper.readValue(jsonString, (JavaType)type);
        return alerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readInitProperties() {
        Properties props = new Properties();
        InputStream is = null;
        String optFolder = System.getProperty(INSTALL_FOLDER_PROPERTY);
        if (optFolder == null) {
            optFolder = "/opt/tandbergtv/cms";
        }
        try {
            File f = new File(optFolder, PROPERTIES_FILE);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException e) {
            logger.debug((Object)"Can not load properties from conf/neptune/alerts.properties", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Can not close input stream for properties file conf/neptune/alerts.properties", (Throwable)e);
                }
            }
        }
        return props;
    }
}

