package com.tandbergtv.neptune.ui.componentmgr.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.componentmgr.client.ComponentManagerComponentPermissions;
import com.tandbergtv.neptune.ui.componentmgr.client.i18n.ComponentManagerConstants;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.view.ComponentView;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;

public class ComponentManagerComponent extends ComponentBase {

	private final ComponentManagerConstants constants = GWT.create(ComponentManagerConstants.class);

	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		return null;
	}

	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		List<MenuItemBase> adminGroup = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager.isAuthorized(ComponentManagerComponentPermissions.COMPONENT_VIEW)) {
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new ComponentView());
			String displayName = constants.componentMenuItem();
			final WidgetMenuItem menuItem = new WidgetMenuItem(displayName, displayName, factory,
			        factory.getAnchorChangeListener());
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);			
		}

		/* Always return the group even if its empty */
		tabs.add(new MenuItemProxy("Admin", adminGroup));
		
		return tabs;
	}

	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		return new ArrayList<E>();
	}

	@Override
	public String getName() {
		return "COMPONENT_MANAGER";
	}

	@Override
	public String getDisplayName() {
		return constants.componentDisplayName();
	}
}
