/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import com.tandbergtv.neptune.realm.persist.ExternalUser;
import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapConfigurationManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapContextManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.AuthenticationConfiguration;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class LdapUserAuthenticationService
implements IUserAuthenticationService {
    private static final Logger logger = Logger.getLogger(LdapUserAuthenticationService.class);
    private final LdapConfigurationManager configurationManager;
    private final LdapContextManager contextManager;
    private final Map<String, String> properties;
    private static final String AUTH_ELEMENT = "authenication";

    public LdapUserAuthenticationService(LdapConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.contextManager = new LdapContextManager(configurationManager);
        this.properties = new HashMap<String, String>();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void authenticateUser(String userName, String password, String externalKey) throws LoginException {
        this.validateConfiguration();
        String userDN = externalKey;
        if (userDN == null) {
            if (this.isSearchAndAuthenticate()) {
                userDN = this.searchForUserDN(userName);
            } else if (this.isAuthenticateOnly()) {
                userDN = this.buildUserDN(userName);
            }
        }
        this.authenticateCredentials(userDN, password);
    }

    private AuthenticationConfiguration getConfiguration() {
        return this.configurationManager.getConfiguration().getAuthenication();
    }

    private boolean isSearchAndAuthenticate() {
        AuthenticationConfiguration configuration = this.getConfiguration();
        return configuration != null && configuration.getSearchAndAuthenticate() != null;
    }

    private boolean isAuthenticateOnly() {
        AuthenticationConfiguration configuration = this.getConfiguration();
        return configuration != null && configuration.getAuthenticateOnly() != null;
    }

    private void validateConfiguration() {
        if (this.isSearchAndAuthenticate() && this.isAuthenticateOnly()) {
            String msg = "authentication must specify only one of 'searchAndAuthenticate' and 'authenticateOnly'";
            throw this.configurationManager.createConfigurationException(AUTH_ELEMENT, msg);
        }
        if (!this.isSearchAndAuthenticate() && !this.isAuthenticateOnly()) {
            String msg = "authentication must specify one of 'searchAndAuthenticate' or 'authenticate";
            throw this.configurationManager.createConfigurationException(AUTH_ELEMENT, msg);
        }
    }

    private String searchForUserDN(String userName) throws LoginException {
        AuthenticationConfiguration authConfig = this.getConfiguration();
        LdapQuery query = authConfig.getSearchAndAuthenticate().getFindByUserNameQuery();
        String userDN = null;
        LdapContext context = null;
        try {
            context = this.contextManager.openContext();
            String baseDN = this.contextManager.getBaseDN(query);
            String filterExpression = query.getFilterExpression();
            String[] filterArguments = new String[]{userName};
            SearchControls searchControls = this.contextManager.buildSearchControls(query);
            searchControls.setCountLimit(2L);
            List<ExternalUser> users = this.contextManager.search(context, baseDN, filterExpression, filterArguments, searchControls);
            if (users.size() > 1) {
                String name = "findByUserNameQuery";
                String msg = "query returns more than 1 record when only 1 record is expected.";
                throw this.configurationManager.createConfigurationException(name, msg);
            }
            if (users.size() == 0) {
                throw new AccountNotFoundException("The user name is invalid.");
            }
            String string = userDN = users.get(0).getKey();
            return string;
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to query LDAP to determine user DN based on the user name.", (Throwable)e);
            throw new LoginException("Authentication failure.");
        }
        finally {
            this.contextManager.closeContext(context);
        }
    }

    private String buildUserDN(String userName) {
        return this.getUserDNPrefix() + userName + this.getUserDNSuffix();
    }

    private String getUserDNPrefix() {
        String prefix = this.getConfiguration().getAuthenticateOnly().getUserDNPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    private String getUserDNSuffix() {
        String suffix = this.getConfiguration().getAuthenticateOnly().getUserDNSuffix();
        if (suffix == null) {
            suffix = "";
        }
        return suffix;
    }

    private void authenticateCredentials(String userDN, String password) throws LoginException {
        LdapContext context = null;
        try {
            context = this.contextManager.openContext(userDN, password);
        }
        catch (NamingException e) {
            logger.debug((Object)("User[" + userDN + "]: LDAP authentication failed."), (Throwable)e);
            throw new FailedLoginException("Invalid username / password.");
        }
        finally {
            this.contextManager.closeContext(context);
        }
    }
}

