/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OAuthHandler {
    private String url = "http://localhost";
    private String username = "admin";
    private String password = "admin";
    private String loginPage = "";
    private String charset = "UTF-8";
    private String loginAction = "";
    private CookieManager manager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);

    public OAuthHandler(String url, String username, String password) throws UnsupportedEncodingException {
        if (url != null && !url.isEmpty()) {
            this.url = url;
        }
        if (username != null && !username.isEmpty()) {
            this.username = username;
        }
        if (password != null && !password.isEmpty()) {
            this.password = password;
        }
        this.loginAction = "login.do?j_username=" + URLEncoder.encode(this.username, this.charset) + "&" + "j_password=" + URLEncoder.encode(this.password, this.charset) + "&" + "login=" + URLEncoder.encode("Log In", this.charset);
    }

    public OAuthHandler(String url, String username, String password, String loginPage) throws UnsupportedEncodingException {
        this(url, username, password);
        this.loginPage = loginPage;
    }

    public CookieHandler login() throws Exception {
        CookieHandler oldHandler = CookieHandler.getDefault();
        try {
            CookieHandler.setDefault(this.manager);
            String method = "GET";
            String url = this.url;
            HttpURLConnection originalRequestConnection = this.getSSLconnection(url, method, this.loginPage);
            originalRequestConnection.connect();
            String redirectLocation = "";
            while (originalRequestConnection.getResponseCode() / 100 == 3) {
                redirectLocation = originalRequestConnection.getHeaderField("Location");
                originalRequestConnection = this.getSSLconnection(redirectLocation, method, "");
                originalRequestConnection.connect();
            }
            method = "POST";
            HttpURLConnection loginConnection = this.getSSLconnection(redirectLocation.replace("login.jsp", this.loginAction), method, "");
            loginConnection.connect();
            while (loginConnection.getResponseCode() / 100 == 3) {
                redirectLocation = loginConnection.getHeaderField("Location");
                loginConnection = this.getSSLconnection(redirectLocation, method, "");
                loginConnection.connect();
            }
            CookieManager cookieManager = this.manager;
            return cookieManager;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CookieHandler.setDefault(oldHandler);
        }
    }

    private HttpURLConnection getSSLconnection(String ip, String method, String entryPage) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        URL url = entryPage != null && !entryPage.isEmpty() ? new URL(ip + "/" + entryPage) : new URL(ip);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        return conn;
    }

    private void printResponse(HttpURLConnection connection) throws IOException {
        String temp = connection.getHeaderField(0);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilderError = new StringBuilder();
        BufferedReader reader = null;
        BufferedReader errorReader = null;
        int i = 1;
        String headerKey = connection.getHeaderFieldKey(i);
        System.out.println("## DEBUG -- " + connection.getHeaderField(0));
        while (headerKey != null) {
            System.out.println("## DEBUG -- " + headerKey + " : " + connection.getHeaderField(i));
            headerKey = connection.getHeaderFieldKey(++i);
        }
        System.out.println();
        if (temp.contains(" 200 OK")) {
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            System.out.println(stringBuilder);
        } else if (temp.contains("301") || temp.contains("302")) {
            System.out.println("Redirect Location: " + connection.getHeaderField("Location"));
        } else {
            errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            String line = null;
            while ((line = errorReader.readLine()) != null) {
                stringBuilderError.append(line);
            }
            System.out.println(stringBuilderError);
        }
        System.out.println();
        System.out.println("- - - - -");
        System.out.println();
    }

    public CookieManager getManager() {
        return this.manager;
    }

    public void setManager(CookieManager manager) {
        this.manager = manager;
    }
}

