/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.alerts.rest.client;

import com.ericsson.neptune.alerts.entity.AlertsSummary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;

public class AlertsConsumer {
    String url;
    String name;
    String password;
    int connTimeout = 2000;
    int readTimeout = 3000;

    public AlertsConsumer(String url, String name, String password) {
        this.url = url;
        this.name = name;
        this.password = password;
    }

    public AlertsSummary getSummary() {
        AlertsSummary summary = null;
        try {
            String authString = this.name + ":" + this.password;
            byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
            String authStringEnc = new String(authEncBytes);
            URL urlComponent = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)urlComponent.openConnection();
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(this.connTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ObjectMapper mapper = new ObjectMapper();
            summary = (AlertsSummary)mapper.readValue((Reader)br, AlertsSummary.class);
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return summary;
    }

    public static void main(String[] args) {
        String url = "http://localhost:8080/sample/services/alerts/count?startTime=2014-01-08%2010:52:30";
        String name = "admin";
        String password = "admin";
        AlertsConsumer test = new AlertsConsumer(url, name, password);
        System.out.println(test.getSummary());
    }
}

