package com.tandbergtv.neptune.ui.realm.client.alerts.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.UiAlertItem;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.UiRecoveryItem;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.UiRecoveryItemType;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineHTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.SimpleListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class AlertItemsTableDataProvider implements DataProvider<String, AlertItemRecord> {

	AlertTableView view;
	private List<Column<?, AlertItemRecord>> columns = null;

	/* The RPC service */
	private RealmConstants constants = GWT.create(RealmConstants.class);

	/* The column names */
	private static final String TIMESTAMP_COLUMN = "timestamp";
	private static final String NAME_COLUMN = "name";
	private static final String SEVERITY_COLUMN = "severity";
	private static final String MESSAGE_COLUMN = "message";
	// private static final String TYPE_COLUMN = "type";
	private static final String RECOVERY_OPTIONS_COLUMN = "recovery options";

	/* Column widths */
	private static final String TIMESTAMP_COLUMN_WIDTH = "15%";
	private static final String NAME_COLUMN_WIDTH = "20%";
	private static final String SEVERITY_COLUMN_WIDTH = "10%";
	private static final String MESSAGE_COLUMN_WIDTH = "45%";
	// private static final String TYPE_COLUMN_WIDTH = "10%";
	private static final String RECOVERY_OPTIONS_WIDTH = "10%";

	private static final String DETAILED_MSG_ICON = "realm/images/help.png";

	AlertItemsTableDataProvider(AlertTableView view) {
		this.view = view;
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public List<Column<?, AlertItemRecord>> getColumns() {
		if (this.columns == null) {
			/* Build the columns if not previously built */
			this.columns = new ArrayList<Column<?, AlertItemRecord>>();

			/* The timestamp column */
			String timestampDisplayName = constants.timestampColumn();
			ColumnBase<String, AlertItemRecord> timestampColumn = new ColumnBase<String, AlertItemRecord>(
					TIMESTAMP_COLUMN, timestampDisplayName) {
				public View<String> getView(AlertItemRecord record) {
					return new LabelStringView(record.getUiAlertItem().getTimeStamp());
				}

				@Override
				public String getColumnWidth() {
					return TIMESTAMP_COLUMN_WIDTH;
				}
			};
			timestampColumn.setCellStyle(TableConstants.STYLE_DATACELL_DATE);
			this.columns.add(timestampColumn);

			/* The item name column */
			String nameDisplayName = constants.itemNameColumn();
			ColumnBase<String, AlertItemRecord> nameColumn = new ColumnBase<String, AlertItemRecord>(
					NAME_COLUMN, nameDisplayName) {
				public View<String> getView(AlertItemRecord record) {
					return new LabelStringView(record.getUiAlertItem().getItemName());
				}

				@Override
				public String getColumnWidth() {
					return NAME_COLUMN_WIDTH;
				}
			};
			nameColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
			this.columns.add(nameColumn);

			/* The severity column */
			String severityDisplayName = constants.severityColumn();
			Column<String, AlertItemRecord> severityColumn = prepareSeverityColumn(SEVERITY_COLUMN,
					severityDisplayName);
			this.columns.add(severityColumn);

			/* The message name column */
			String messageDisplayName = constants.messageColumn();
			Column<String, AlertItemRecord> messageColumn = prepareMessageColumn(MESSAGE_COLUMN,
					messageDisplayName);
			this.columns.add(messageColumn);

			/* Recovery Option column */
			Column<String, AlertItemRecord> recoveryOptions = prepareRecoveryOptionsColumn(
					RECOVERY_OPTIONS_COLUMN, constants.recoveryOptionColumn());
			this.columns.add(recoveryOptions);
		}

		return this.columns;
	}

	private Column<String, AlertItemRecord> prepareSeverityColumn(String columnName,
			String displayName) {
		ColumnBase<String, AlertItemRecord> column = null;

		column = new ColumnBase<String, AlertItemRecord>(columnName, displayName) {
			@Override
			public View<String> getView(final AlertItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						String severity = record.getUiAlertItem().getSeverity();
						ImageWidget image = AlertMessagesPortlet.getImage(severity.toString()
								.toUpperCase());
						return image;
					}

					@Override
					public void release() {
					}
				};
			}

			@Override
			public String getColumnWidth() {
				return SEVERITY_COLUMN_WIDTH;
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_ICON);

		return column;
	}

	private Column<String, AlertItemRecord> prepareMessageColumn(String columnName,
			String displayName) {
		ColumnBase<String, AlertItemRecord> column = null;
		column = new ColumnBase<String, AlertItemRecord>(columnName, displayName) {
			@Override
			public View<String> getView(final AlertItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_TEXT;
					}

					@Override
					public Widget getWidget() {
						String message = record.getUiAlertItem().getMessage();
						if (message == null || message.isEmpty()) {
							return new LabelWidget("");
						}
						final String detMessage = record.getUiAlertItem().getDetailedMessage();
						if (detMessage == null || detMessage.isEmpty()) {
							return new InlineHTMLWidget(message);
						}
						InlineHTMLWidget messageLink = new InlineHTMLWidget(message);

						ImageWidget detIcon = new ImageWidget(DETAILED_MSG_ICON);
						detIcon.setTitle(detMessage);
						detIcon.addClickHandler(new ClickHandler() {
							@Override
							public void onClick(ClickEvent event) {
								final ExtMsgPopup popUp = new ExtMsgPopup(detMessage);
								popUp.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
									public void setPosition(int offsetWidth, int offsetHeight) {
										int left = (Window.getClientWidth() - offsetWidth) / 3;
										int top = (Window.getClientHeight() - offsetHeight) / 3;
										popUp.setPopupPosition(left, top);
									}
								});
							}
						});
						FlowPanel descriptionMessagePanel = new FlowPanel();
						descriptionMessagePanel.add(messageLink);
						descriptionMessagePanel.add(detIcon);
						return descriptionMessagePanel;
					}

					@Override
					public void release() {
					}
				};

			}

			@Override
			public String getColumnWidth() {
				return MESSAGE_COLUMN_WIDTH;
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);

		return column;
	}

	private Column<String, AlertItemRecord> prepareRecoveryOptionsColumn(String columnName,
			String displayName) {
		ColumnBase<String, AlertItemRecord> column = new ColumnBase<String, AlertItemRecord>(
				columnName, displayName) {

			@Override
			public View<String> getView(final AlertItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_TEXT;
					}

					@Override
					public Widget getWidget() {
						final HorizontalPanel recoveryOptionsPanel = new HorizontalPanel();

						if (record.getUiAlertItem().getRecoveryOptions() != null
								&& !record.getUiAlertItem().getRecoveryOptions().isEmpty()) {

							final SimpleListBoxWidget recoveryListBox = new SimpleListBoxWidget(
									false);
							recoveryListBox.addItem("");

							for (UiRecoveryItem actionItem : record.getUiAlertItem()
									.getRecoveryOptions()) {
								if (actionItem.getType() == UiRecoveryItemType.Hyperlink) {
									recoveryListBox.addItem(actionItem.getName() + " (link)");
								} else {
									recoveryListBox.addItem(actionItem.getName());
								}
							}

							recoveryOptionsPanel.add(recoveryListBox);

							Button fixButton = new Button();
							fixButton.setText("Fix");
							fixButton.addClickHandler(new ClickHandler() {
								@Override
								public void onClick(ClickEvent event) {
									int selectedIndex = recoveryListBox.getSelectedIndex();

									if (selectedIndex != 0
											&& !(selectedIndex > record.getUiAlertItem()
													.getRecoveryOptions().size())) {
										// Offset the index for the empty default option
										UiRecoveryItem recoveryItem = record.getUiAlertItem()
												.getRecoveryOptions().get(selectedIndex - 1);

										view.handleFixButtonClick(recoveryItem);
										recoveryOptionsPanel.clear();
										recoveryOptionsPanel
												.add(new ImageWidget("images/gear.png"));
									}
								}
							});
							recoveryOptionsPanel.add(fixButton);
						} else {
							recoveryOptionsPanel.add(new LabelWidget(constants.noFixAvailable()));
						}

						return recoveryOptionsPanel;
					}

					@Override
					public void release() {
					}
				};
			}

			@Override
			public String getColumnWidth() {
				return RECOVERY_OPTIONS_WIDTH;
			}
		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_GENERAL);

		return column;
	}

	@Override
	public void getRecords(final AsyncCallback<List<AlertItemRecord>> callback) {
		PageFeature pageFeature = view.getTable().getPageFeature();
		int pageSize = pageFeature.getPageSize();
		int startIndex = (pageFeature.getPageNumber() - 1) * pageSize;

		List<UiAlertItem> alertItems = view.getPagedAlertItems(startIndex, pageSize);
		List<AlertItemRecord> records = new ArrayList<AlertItemRecord>();
		for (UiAlertItem alertItem : alertItems) {
			AlertItemRecord record = new AlertItemRecord(alertItem);
			records.add(record);
		}
		callback.onSuccess(records);
	}

	@Override
	public void getRecord(String key, AsyncCallback<AlertItemRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	class ExtMsgPopup extends PopupPanel {
		public ExtMsgPopup(String detMsg) {
			// PopupPanel's constructor takes 'auto-hide' as its boolean parameter.
			// If this is set, the panel closes itself automatically when the user
			// clicks outside of it.
			super(true);

			// PopupPanel is a SimplePanel, set it's widget property to TextArea
			TextArea txtArea = new TextArea();
			txtArea.setText(detMsg);
			txtArea.setWidth("750px");
			txtArea.setVisibleLines(40);
			txtArea.setReadOnly(true);
			setWidget(txtArea);
		}
	}
}
