package com.tandbergtv.neptune.ui.realm.client.alerts.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class AlertsLazyView extends LazyView {
	private VerticalPanel mainPanel;
	private HeaderPanel headerPanel;
	private SimplePanel widgetPanel;
	private AlertTableView tableView;
	private ResizableContainer container;
	private BusyIndicator busyIndicator = new BusyIndicator(this);
	private RealmConstants constants;

	/* Styles / constants */
	private static final String STYLE_NAME = "realm-UserView"; 
	private static final String STYLE_LIST_VIEW = "listView";
	private static final String STYLE_HEADER_PANEL = STYLE_NAME + "-headerPanel";
	private static final String STYLE_WIDGET_PANEL = STYLE_NAME + "-widgetPanel";
	private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
	private static final String ACTION_ITEMS_IMAGE_URL = "neptune_framework/images/ico_admin.png";
	
	public AlertsLazyView() {
		addStyleName(STYLE_NAME);
	}
	
	/*
	 * Get the constants
	 */
	private RealmConstants getConstants() {
		if (constants == null)
			constants = GWT.create(RealmConstants.class);

		return constants;
	}
	
	/*
	 * Show the header panel
	 */
	private void showHeaderPanel(String heading, String styleName) {
		headerPanel.setLabel(heading);
		headerPanel.setVisible(true);
		mainPanel.setStyleName(styleName);
	}
   
	
	/* Added for ECMS  */
	private void showHeaderPanel(String heading, String styleName,String imageUrl) {
	
		headerPanel.setLabel(heading);
			
		Image image=new Image(ACTION_ITEMS_IMAGE_URL);
		image.setStyleName(STYLE_HEADER_IMAGE);
	 
		headerPanel.setImage(image);
		
	
		headerPanel.setVisible(true);
		mainPanel.setStyleName(styleName);
	}
	/*
	 * Hide the header panel
	 */
	private void hideHeaderPanel() {
		headerPanel.setLabel("");
		headerPanel.setVisible(false);
		mainPanel.setStyleName(STYLE_LIST_VIEW);
	}
	
	@Override
	public String getAnchor() {
		String anchor = null;
		Widget widget = getWidgetInPanel();
		if (tableView != null && widget == tableView) {
			/* Showing the list view, get table anchor */
			anchor = tableView.getAnchor();
		}
		else
			anchor = "";
		return anchor;
	}

	@Override
	protected void setWidgetAnchor(String anchor) {
		tableView = new AlertTableView(busyIndicator);
		showTableView();
		tableView.setAnchor(anchor);
		tableView.refresh();
	}

	@Override
	protected Widget createWidget() {
		mainPanel = new VerticalPanel();
		//mainPanel.setSpacing(5);
		mainPanel.setStyleName(STYLE_LIST_VIEW);

		/* At the very top is the header panel */
		headerPanel = new HeaderPanel("");
		headerPanel.setVisible(false);
		//headerPanel.addStyleName(STYLE_HEADER_PANEL);
		mainPanel.add(headerPanel);
		
		/* Add the widget panel */
		widgetPanel = new SimpleContainer();
		widgetPanel.addStyleName(STYLE_WIDGET_PANEL);
		mainPanel.add(widgetPanel);

		container = new ResizableContainer(widgetPanel, null, null);
		mainPanel.add(container);
		container.addHeightOffsettingWidget(headerPanel);
		
		return mainPanel;
	}

	/*
	 * Get the widget being displayed in the widget panel
	 */
	private Widget getWidgetInPanel() {
		if (widgetPanel == null)
			return null;

		return widgetPanel.getWidget();
	}

	/*
	 * Set the panel widget
	 */
	private void setWidgetInPanel(Widget widget) {
		widgetPanel.setWidget(widget);
	}
	
	
	/*
	 * Show the table view in the widget panel
	 */
	public void showTableView() {
		setWidgetInPanel(tableView);
		//showHeaderPanel(getConstants().componentListViewHeading(), STYLE_LIST_VIEW);
		showHeaderPanel(getConstants().alertsStatusPortletHeader(), STYLE_LIST_VIEW, ACTION_ITEMS_IMAGE_URL);  /* Modified for ECMS */
	}

}
