/*
 * Created on Jan 22, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.framework.client.application;

import com.google.gwt.user.client.ui.Widget;

/**
 * Event fired when the user attempts to log in
 * 
 * @author Vijay Silva
 */
public class LoginEvent {

	/* Properties */
	private final Widget source;
	private final String userName;
	private final String password;

	/**
	 * Constructor
	 * 
	 * @param source The event source
	 * @param userName The user name
	 * @param password The password
	 */
	public LoginEvent(Widget source, String userName, String password) {
		this.source = source;
		this.userName = userName;
		this.password = password;
	}

	/**
	 * Get the event source
	 * 
	 * @return The event source
	 */
	public Widget getSource() {
		return source;
	}

	/**
	 * Get the user name used for log-in
	 * 
	 * @return The user name
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * Get the password used for log-in
	 * 
	 * @return The password
	 */
	public String getPassword() {
		return password;
	}
}
