package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table.RefreshListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

final class ModuleTable extends Composite {

	private final Map<Long, CheckBoxWidget> checkBoxMap;
	private Collection<Long> enabledPermissions;
	private Table<Long, ModuleRecord> table;
	private final SortFeatureImpl<Long, ModuleRecord> sortFeature;
	private ModuleDataProvider modDataProvider;
	
	private static final String TABLE_STYLE			= "permissions-table";

	
	public ModuleTable(List<UiModule> model) {
		checkBoxMap = new HashMap<Long, CheckBoxWidget>();
		enabledPermissions = new ArrayList<Long>();
		
		modDataProvider = new ModuleDataProvider(this, model);
		modDataProvider.initialize(null);
		table = new Table<Long, ModuleRecord>(modDataProvider);
		table.addStyleName(TABLE_STYLE);
		sortFeature = new SortFeatureImpl<Long, ModuleRecord>(modDataProvider.columnModuleName, SortOrder.ASCENDING );
		table.addSortFeature(sortFeature);
		initializeTable(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Should not happen */
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				table.reset(false);
				table.showListView();
				table.refresh();
			}
		});
		
		table.addRefreshListener( new ModuleTableRefreshListener() );
		
		
		
		initWidget( table );
	}
	
	public void reset() {
		if (getWidget() == null)
			return;

		if (table.isInitialized()) {
			table.reset();
			table.showListView();
		}
	}
	
	private void initializeTable(final AsyncCallback<Void> callback) {
		if (table.isInitialized()) {
			callback.onSuccess(null);
			return;
		}

		table.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Will never happen */
				if (callback != null)
					callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				if (callback != null)
					callback.onSuccess(result);
			}
		});
	}	
	
	public void setData(Collection<Long> data) {
		enabledPermissions = data;
		
		// reset to false
		for (CheckBoxWidget checkBox : checkBoxMap.values())
			checkBox.setValue(false);

		// set the checked ones
		for (Long permissionId : data)
			checkBoxMap.get(permissionId).setValue(true);
	}

	public Collection<Long> getData() {
		Collection<Long> checked = new ArrayList<Long>();
		for (Long key : checkBoxMap.keySet())
			if (checkBoxMap.get(key).getValue())
				checked.add(key);
		return checked;
	}
	
	public Table<Long, ModuleRecord> getTable() {
		return table;
	}
	
	public Map<Long, CheckBoxWidget> getCheckBoxMap() {
		return checkBoxMap;
	}
	
	public Collection<Long> getEnabledPermissions() {
		return enabledPermissions;
	}
	
	private class ModuleTableRefreshListener implements RefreshListener {
	
		@Override
		public void updated() {
			for (Long key : getEnabledPermissions() ) {
				if( getCheckBoxMap().get(key) != null ) {
					getCheckBoxMap().get(key).setValue(true);
				}
			}
			
		}

	}

}
