package com.tandbergtv.neptune.ui.realm.client.alerts.view;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.IAlertsUIService;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.IAlertsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.UiAlertItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AlertTableView extends LazyView{
	private VerticalContainer tableContainer;
	private Table<String, AlertItemRecord> alertListTable;
	AlertItemsTableDataProvider tableDataProvider;
	private final BusyIndicator busyIndicator;
	
	List<UiAlertItem> uiAlertItems;
	
	/* The RPC service */
	private final IAlertsUIServiceAsync service = GWT.create(IAlertsUIService.class);

	/* Styles / Constants */
	private static final String STYLE_NAME = "realm-UserTableView" ; //"realm-AlertTableView";
	private static final String STYLE_TABLE = STYLE_NAME + "-table";
	private static final String COOKIE_PREFIX = "alertList";

	/**
	 * Constructor
	 */
	public AlertTableView(BusyIndicator busyIndicator) {
		this.busyIndicator = busyIndicator;
		addStyleName(STYLE_NAME);
	}
	
	
	public void refresh() {
		service.getAlertItems(new NeptuneAsyncCallback<List<UiAlertItem>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				Window.alert("Error getting alert items:" + caught.getMessage());	
		        getBusyIndicator().hide();
			}

			@Override
			public void onNeptuneSuccess(List<UiAlertItem> alerts) {
		        getBusyIndicator().hide();
		        uiAlertItems = alerts;
		        refreshTable();
			}		
		});	
	}
	
	List<UiAlertItem> getPagedAlertItems(int startIndex, int pageSize) {
		List<UiAlertItem> alertItems = new ArrayList<UiAlertItem>();		
		int index = startIndex;
		while ((index-startIndex) < pageSize) {
			if (index < this.uiAlertItems.size()) {
				alertItems.add(this.uiAlertItems.get(index));
				index++;
			}	
			else 
				break;
		}
		return alertItems;	
	}
   	
	
	/**
	 * Refresh the view with new state
	 */
	public void refreshTable() {
		ensureWidget();
		/* Initialize and refresh the table */
		initializeTable(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				Window.alert("initializeTable:" + caught.getMessage());	
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				alertListTable.getPageFeature().setPageNumber(1);
				alertListTable.getPageFeature().setRecordCount(uiAlertItems.size());
				alertListTable.refresh();
			}
		});
	
	}
	
	private void initializeTable(final AsyncCallback<Void> callback) {
		if (alertListTable.isInitialized()) {
			callback.onSuccess(null);
			return;
		}

		alertListTable.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Will never happen */
				if (callback != null)
					callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				if (callback != null)
					callback.onSuccess(result);
			}
		});
	}
	
	public void reset() {
		if (getWidget() == null)
			return;

		if (alertListTable.isInitialized()) {
			alertListTable.reset();
			alertListTable.showListView();
		}
	}
	
	@Override
	public String getAnchor() {
		if (getWidget() == null)
			return "";

		return alertListTable.getBookmarkFeature().buildAnchor(alertListTable.getTableAnchor());
	}

	
	@Override
	protected void setWidgetAnchor(final String anchor) {
		/* Reset the view */
		reset();

		/* Update the table */
		initializeTable(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				/* Should not happen */
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				/* The table is refreshed, set the table anchor */
				alertListTable.setAnchor(anchor);
			}
		});
	}

	@Override
	protected Widget createWidget() {
		tableContainer = new VerticalContainer();

		/* Build the data provider and the table widget */
		tableDataProvider = new AlertItemsTableDataProvider(this);
		alertListTable = new Table<String, AlertItemRecord>(tableDataProvider);
		alertListTable.addStyleName(STYLE_TABLE);
		tableContainer.add(alertListTable);

		/* Add paging feature */
		PageFeature pageFeature = new CookieStoreBasedPageFeatureImpl(COOKIE_PREFIX);
		pageFeature.setShowTotalCount(true);
		alertListTable.addPageFeature(pageFeature);

		return tableContainer;
	}

	BusyIndicator getBusyIndicator() {
		return busyIndicator;
	}

	Table<String, AlertItemRecord> getTable() {
		return alertListTable;
	}
}
