package com.tandbergtv.neptune.ui.framework.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.tandbergtv.neptune.widgettoolkit.client.event.NeptuneEvent;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListener;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;

public class EventManager implements EventListenerRegistry, EventSink {
	private final Map<Class<? extends NeptuneEvent>, List<EventListener<NeptuneEvent>>> classToEventListenerMap = new HashMap<Class<? extends NeptuneEvent>, List<EventListener<NeptuneEvent>>>();

	@SuppressWarnings( { "unchecked" })
	public <E extends NeptuneEvent> void registerEventListener(Class<E> clazz,
			EventListener<E> listener) {
		// ensure there is a list
		if (classToEventListenerMap.get(clazz) == null)
			classToEventListenerMap.put(clazz,
					new ArrayList<EventListener<NeptuneEvent>>());

		// add listener to list
		classToEventListenerMap.get(clazz).add((EventListener<NeptuneEvent>) listener);
	}

	@Override
	public <E extends NeptuneEvent> void fireEvent(E event) {
		List<EventListener<NeptuneEvent>> listeners = classToEventListenerMap
				.get(event.getClass());
		if (listeners != null) {
			for (EventListener<NeptuneEvent> listener : listeners)
				listener.eventOccured(event);
		}
	}
}
