package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;

public class BookmarkFeatureImpl implements BookmarkFeature {

	private AnchorTokenizer tokenizer = new AnchorTokenizer();

	/* The character that terminates the view name and marks the start of the anchor tokens */
	protected static final String VIEW_NAME_TERMINATOR = "?";

	public BookmarkFeatureImpl() {
	}

	@Override
	public String buildAnchor(TableAnchor anchor) {
		StringBuilder anchorBuffer = new StringBuilder();

		/* First add the view name */
		String viewName = anchor.getViewName();
		if (viewName != null)
			anchorBuffer.append(viewName);

		/* Add the separator between view name and tokens */
		anchorBuffer.append(VIEW_NAME_TERMINATOR);

		/* Add the tokens */
		anchorBuffer.append(tokenizer.buildAnchor(anchor.getTokens()));

		return anchorBuffer.toString();
	}

	@Override
	public TableAnchor parseAnchor(String anchor) {
		TableAnchor tableAnchor = new TableAnchor();

		if (anchor != null) {
			int index = anchor.indexOf(VIEW_NAME_TERMINATOR);
			if (index == -1) {
				tableAnchor.setViewName(anchor);
			} else {
				tableAnchor.setViewName(anchor.substring(0, index));
				if (anchor.length() > (++index)) {
					String tokens = anchor.substring(index);
					tableAnchor.getTokens().putAll(tokenizer.parseAnchor(tokens));
				}
			}
		}

		return tableAnchor;
	}

	@Override
	public void reset() {
	}
}
