/*
 * Created on Jan 7, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import java.util.List;

import com.google.gwt.user.client.ui.Widget;

/**
 * Event that indicates that the selected records changed
 * 
 * @author Daniel Silva
 */
public class SelectionChangeEvent<K, R extends Record<K>> extends TableViewEvent {

	private Widget source;
	
	private List<R> selectedRecords;
	
	/**
	 * Constructor
	 * 
	 * @param source The source widget
	 * @param selectedRecords The selected records
	 */
	public SelectionChangeEvent(Widget source, List<R> selectedRecords) {
		this.source = source;
		this.selectedRecords = selectedRecords;
	}

	/**
	 * Get the source widget
	 * 
	 * @return The source widget
	 */
	public Widget getSource() {
		return source;
	}
	
	/**
	 * Get the selected records
	 * 
	 * @return The selected record
	 */
	public List<R> getSelectedRecords() {
		return selectedRecords;
	}

}
