/*
 * Created on Jun 29, 2009
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import java.util.Iterator;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Tool;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasDocumentAttachHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasDocumentDetachHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasRefreshHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;

/**
 * The toolkit portlet widget that is displayed in the 'Home' page of the application.
 * 
 * @author Raj Prakash
 * @author Vijay Silva
 * @author Daniel Paranhos
 */
@SuppressWarnings("unchecked")
public class Portlet extends com.gwtext.client.widgets.Panel implements
        HasDocumentAttachHandlers, HasDocumentDetachHandlers, HasCloseHandlers<Portlet>, HasRefreshHandlers {

	private String id;
	private String displayName;
	private final String cls = "x-portlet";
	private HandlerRegistration lastRefreshHandler = null;

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet()
	 */
	public Portlet(String id) {
		this(id, "");
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param displayName the portlet display name
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet()
	 */
	public Portlet(String id, String displayName) {
		setCls(cls);
		this.id = id;
		this.displayName = displayName;
		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param title the portlet title
	 * @param html the html content
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet(String, String)
	 */
	public Portlet(String id, String title, String html) {
		this(id, title);
		setHtml(html);
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param title the portlet title
	 * @param html the html content
	 * @param tools the toolbar tools
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet(String, String, Tool[])
	 */
	public Portlet(String id, String title, String html, Tool[] tools) {
		this(id, title, html);
		setTools(tools);
	}
	
	@Override
	public void setTitle(String title) {
		this.displayName = title;
	}

	/**
	 * Gets the portlet id
	 * 
	 * @return the portlet id
	 */
	public String getPortletId() {
		return id;
	}

	/**
	 * Gets the portlet display name
	 * 
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Gets the portlet display name
	 * 
	 * @param displayName the display name
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	@Override
	public Iterator<Widget> iterator() {
		return super.iterator();
	}
	
	protected void update() {
		if (this.lastRefreshHandler != null) {
			this.fireEvent(new RefreshEvent());   // local Portlet
		} else {
			postUpdateWrapper();   // remote Portlet
		}
	}
	
	private void postUpdateWrapper() {
		postUpdate(id, Integer.toString(this.getElement().getOffsetHeight()), displayName);
	}

	/**
	 * Notify the parent page to update the height & title of this portlet
	 * 
	 * @param id - portlet id
	 * @param height - height in pixels
	 * @param title - portlet title
	 */
	private final native void postUpdate(String id, String height, String title) /*-{
    	$wnd.parent.postMessage("PORTLET_ID=" + id + "&amp;h=" + height + "&amp;title=" + title, '*');
	}-*/;

	// ========================================================================
	// ===================== EVENT REGISTRATION
	// ========================================================================

	@Override
	public HandlerRegistration addDocumentAttachHandler(DocumentAttachHandler handler) {
		return addHandler(handler, DocumentAttachEvent.getType());
	}

	@Override
	public HandlerRegistration addDocumentDetachHandler(DocumentDetachHandler handler) {
		return addHandler(handler, DocumentDetachEvent.getType());
	}

	@Override
	public HandlerRegistration addCloseHandler(CloseHandler<Portlet> handler) {
		return addHandler(handler, CloseEvent.getType());
	}

	@Override
	public HandlerRegistration addRefreshHandler(RefreshHandler handler) {
		lastRefreshHandler =  addHandler(handler, RefreshEvent.getType());
		return lastRefreshHandler;
	}

	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			update();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
		}
	}

}
