package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.checkbox;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;

public class CheckBoxView extends ViewBase<Boolean> {
	protected CheckBoxWidget checkBox;
	
	public CheckBoxView( Boolean value ) {
		super( value );
		setEnabled(true);
	}
	
	public CheckBoxView( Boolean value, Boolean enabled ) {
		super( value );
		setEnabled(enabled);
	}
	
	public CheckBoxWidget getWidget() {
		return checkBox;
	}
	
	public void release() {
		return;
	}
	
	@Override
	protected void preInitialValueSet() {
		checkBox = new CheckBoxWidget("");
		checkBox.setValue( getViewValue() );
	}

	@Override
	protected Boolean getViewValue() {
		// TODO Auto-generated method stub
		return checkBox.getValue();
	}

	@Override
	protected void setViewValue(Boolean value) {
		checkBox.setValue(value);
	}
	
	public void setEnabled( Boolean enabled ) {
		checkBox.setEnabled(enabled);
	}
	
	public Boolean isEnabled() {
		return checkBox.isEnabled();
	}
}
