package com.tandbergtv.neptune.widgettoolkit.client.application;

import com.google.gwt.user.client.ui.Widget;

/**
 * Implementation of {@link WidgetFactory} that always returns the same instance of a widget.
 * 
 * @author trybak
 */
public class SingletonWidgetFactory implements WidgetFactory {

	/* The widget maintained by the factory */
	private final Widget widget;

	/**
	 * Creates a new factory that maintains a single widget
	 * 
	 * @param widget The widget
	 */
	public SingletonWidgetFactory(Widget widget) {
		this.widget = widget;
	}

	/**
	 * Gets the single widget instance associated with the factory
	 * 
	 * @return The widget
	 */
	@Override
	public Widget getInstance() {
		return widget;
	}

	/**
	 * Does nothing since the widget is not created by this factory
	 */
	@Override
	public void release(Widget widget) {
	}
}
