package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * this panel should be used by pages that want to show a header.
 * 
 * @author vaibhav
 */
public class HeaderPanel extends Composite implements INeptuneWidget {
	private static final String STYLE_HEADER_LABEL = "nwt-HeaderPanel-label";
	private static final String STYLE_HEADER = "nwt-HeaderPanel";

	private SimpleContainer mainContainer;
	private VerticalContainer container;
	private LabelWidget label;

	public HeaderPanel(String label) {
		/* Wrap the header panel table in a 'div' to avoid issues with margin on table */
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);

		container = new VerticalContainer();
		container.setVerticalAlignment(ALIGN_MIDDLE);
		mainContainer.setWidget(container);

		this.label = new LabelWidget(label);
		this.label.setStyleName(STYLE_HEADER_LABEL);
		container.add(this.label);

		this.setStyleName(STYLE_HEADER);
	}

	public void setLabel(String label) {
		this.label.setText(label);
	}
}
