/*
 * GWT Portlets Framework (http://code.google.com/p/gwtportlets/)
 * Copyright 2009 Business Systems Group (Africa)
 *
 * This file is part of GWT Portlets.
 *
 * GWT Portlets is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GWT Portlets is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GWT Portlets.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.tandbergtv.neptune.ui.portalpage.client;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.ui.portalpage.client.portaluserpref.UiPortalUserPreference;

import org.gwtportlets.portlet.client.WidgetFactory;

/**
 * Our service interface.
 */
@RemoteServiceRelativePath("service/portalPageService")
public interface PortalPageService extends RemoteService {

    public static class App {
        private static PortalPageServiceAsync ourInstance = null;

        public static synchronized PortalPageServiceAsync get() {
            if (ourInstance == null) {
                ourInstance = (PortalPageServiceAsync)GWT.create(PortalPageService.class);
            }
            return ourInstance;
        }
    }
    
    /**
     * Load the root layout for our application and the page for the
     * history token.
     */
    public PageConfig getRootPage(String historyToken);

    /**
     * Load a page for the history token.
     */
    public PageConfig getPage(String historyToken);

    /**
     * Get default page with all portlets
     */
   // public List<PortletConfig> getPortletConfig();
    
    /**
     * Save user preferences
     */
    public void savePortletConfig(List<UiPortalUserPreference> preferences);

    /**
     * Retrieve user preferences
     */
    public List<UiPortalUserPreference> readPortletConfig();
    
    /**
     * Delete user preference
     */
    public void deletePreference(String component, String key);
    
    /**
     * Refresh the factory with new data from the server.
     */
    @SuppressWarnings("rawtypes")
	public WidgetFactory refresh(String historyToken, WidgetFactory wf)
            throws IllegalArgumentException;

}
