/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link TextBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.TextBox
 * @author Vijay Silva
 */
public class TextBoxWidget extends TextBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.TextBox#TextBox()
	 */
	public TextBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @param text
	 */
	public TextBoxWidget(String text) {
		initializeWidget();
		super.setText(text);
	}
	
	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.TextBox#TextBox(Element)
	 */
	protected TextBoxWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.TextBox#wrap(Element)
	 */
	public static TextBoxWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		TextBoxWidget widget = new TextBoxWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
