/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.search;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

public class EntitySearchService<T> {
    private final String entityName;
    private final String defaultSortField;
    private final SearchMetadata.SortOrder defaultSortOrder;

    public EntitySearchService(Class<T> entityClass, String defaultSortField) {
        this(entityClass, defaultSortField, null);
    }

    public EntitySearchService(Class<T> entityClass, String defaultSortField, SearchMetadata.SortOrder defaultSortOrder) {
        this.entityName = entityClass.getName();
        this.defaultSortField = defaultSortField;
        this.defaultSortOrder = defaultSortOrder;
    }

    public SearchResult<T> getSearchResult(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters, SearchMetadata metadata) {
        List<T> entities = this.getEntityList(entityManager, alias, whereClause, parameters, metadata);
        int count = this.getEntityCount(entityManager, alias, whereClause, parameters);
        return new SearchResult(entities, count);
    }

    public List<T> getEntityList(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters, SearchMetadata metadata) {
        StringBuilder queryBuffer = new StringBuilder(this.buildSelectQueryPart(alias, false));
        if (whereClause != null) {
            queryBuffer.append(whereClause);
        }
        queryBuffer.append(this.buildSortQueryPart(alias, metadata));
        Query query = this.buildQuery(entityManager, queryBuffer.toString(), parameters);
        this.setPagingCriteria(query, metadata);
        List entityList = query.getResultList();
        return entityList;
    }

    public int getEntityCount(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters) {
        StringBuilder queryBuffer = new StringBuilder(this.buildSelectQueryPart(alias, true));
        if (whereClause != null) {
            queryBuffer.append(whereClause);
        }
        Query countQuery = this.buildQuery(entityManager, queryBuffer.toString(), parameters);
        Long count = (Long)countQuery.getSingleResult();
        return count.intValue();
    }

    private String buildSelectQueryPart(String alias, boolean isCount) {
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (isCount) {
            queryBuf.append("COUNT(").append(alias).append(")");
        } else {
            queryBuf.append(alias);
        }
        queryBuf.append(" FROM ").append(this.entityName).append(" ").append(alias).append(" ");
        return queryBuf.toString();
    }

    private String buildSortQueryPart(String alias, SearchMetadata metadata) {
        String sortField = metadata.getSortField();
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append(" ORDER BY ");
        if (sortField != null) {
            queryBuf.append(alias).append(".").append(sortField);
            queryBuf.append(this.getSortOrder(metadata.getSortOrder()));
        }
        if (this.defaultSortField != null && !this.defaultSortField.equals(sortField)) {
            if (sortField != null) {
                queryBuf.append(", ");
            }
            queryBuf.append(alias).append(".").append(this.defaultSortField);
            queryBuf.append(this.getSortOrder(this.defaultSortOrder));
        }
        return queryBuf.toString();
    }

    private String getSortOrder(SearchMetadata.SortOrder sortOrder) {
        return sortOrder == null || sortOrder.equals((Object)SearchMetadata.SortOrder.Ascending) ? " ASC" : " DESC";
    }

    private Query buildQuery(EntityManager entityManager, String queryString, Map<String, Object> parameters) {
        String string = queryString;
        EntityManager entityManager2 = entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? EntitySearchService.createQuery_aroundBody1$advice(this, entityManager2, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager2, string, null) : entityManager2.createQuery(string);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                query.setParameter(key, parameters.get(key));
            }
        }
        return query;
    }

    private void setPagingCriteria(Query query, SearchMetadata metadata) {
        if (metadata.getStartRecord() != null) {
            query.setFirstResult(metadata.getStartRecord().intValue());
        }
        if (metadata.getMaximumRecordCount() != null) {
            query.setMaxResults(metadata.getMaximumRecordCount().intValue());
        }
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(EntitySearchService ajc$this, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

