/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.clustermgmt.ejb;

import com.ericsson.neptune.clustermgmt.HazelcastConfig;
import com.ericsson.neptune.clustermgmt.NodeMembershipListener;
import com.ericsson.neptune.clustermgmt.service.IClusterConfigurationService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.clustermgmt.service.IClusterConfigurationService")
public class ClusterConfigurationService
implements IClusterConfigurationService {
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String PROPERTIES_FILE = "conf/workflow/cluster.properties";
    private static final Logger log = Logger.getLogger(ClusterConfigurationService.class);

    public void create() throws Exception {
        this.joinCluster();
    }

    public void destroy() {
        this.leaveCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readInitProperties() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            File f = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), PROPERTIES_FILE);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (IOException e) {
            log.error((Object)"Can not load properties from conf/workflow/cluster.properties", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close input stream for properties file conf/workflow/cluster.properties", (Throwable)e);
                }
            }
        }
        return props;
    }

    private void joinCluster() {
        Properties props = this.readInitProperties();
        try {
            log.info((Object)"Initializing Hazelcast...");
            Config config = HazelcastConfig.create(props);
            Hazelcast.init((Config)config);
            Cluster cluster = Hazelcast.getCluster();
            cluster.addMembershipListener((MembershipListener)new NodeMembershipListener());
            log.info((Object)"Hazelcast has been initialized.");
        }
        catch (Exception e) {
            log.error((Object)"Can not join cluster", (Throwable)e);
        }
    }

    private void leaveCluster() {
        log.info((Object)"Leaving Hazelcast cluster");
        Hazelcast.shutdownAll();
        log.info((Object)"Left Hazelcast cluster");
    }
}

