package com.tandbergtv.neptune.ui.portalpage.client;

import java.util.ArrayList;
import java.util.List;

import org.gwtportlets.portlet.client.layout.LayoutConstraints;
import org.gwtportlets.portlet.client.layout.RowLayout;
import org.gwtportlets.portlet.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.portalpage.client.portaluserpref.UiPortalUserPreference;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ColumnPanel;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ColumnSizingLayoutPanel;
import com.tandbergtv.neptune.ui.portalpage.client.ui.Gadget;
import com.tandbergtv.neptune.ui.portalpage.client.ui.HtmlGadget;

public class PageUtils {

    public static final int MIN_USABLE_COL_WIDTH = 100;

	/**
	 * getGadgets retrieves all Gadgets in the layout tree.
	 *   This is not restricted to a specific layout
	 * @param widget - next widget in the tree to process
	 * @param list - the complete list of Gadgets
	 * @param url - restrict result to Gadget with specified url
	 * @param id - restrict result to Gadget with specified id
	 * @return Gadget specified by url, if any, null otherwise
	 */
    public static Gadget getGadgets(Widget widget, List<Gadget> list, String url, String id) {
    	if (widget instanceof Gadget) {
    		if (url == null && id == null) {
    			list.add((Gadget) widget);
    		} else if (url != null && (widget instanceof HtmlGadget) && ((HtmlGadget) widget).matchesUrl(url)) {
    			list.add(0, (Gadget) widget);
    			return ((Gadget) widget);
    		} else if (id != null && ((Gadget) widget).getPortletId().equals(id)) {
    			list.add(0, (Gadget) widget);
    			return ((Gadget) widget);
    		}
    	} else if (widget instanceof IndexedPanel) {
    		int numChildren = ((IndexedPanel) widget).getWidgetCount();
    		for (int i=0; i<numChildren; i++) {
    			Gadget next = getGadgets(((IndexedPanel) widget).getWidget(i), list, url, id);
    			if (next != null) {
    				return next;
    			}
    		}
    	}
    	return null;
    }
    
    /**
     * Get the user preferences for Gadget arrangement
     * This is specific to a layout of columns, each containing any number of Gadgets
     */
    public static void getPortalUserPreferences(Widget widget, List<UiPortalUserPreference> list) {
    	getGadgetPreferences(widget, list);
    	List<ColumnPanel> columnList = new ArrayList<ColumnPanel>();
    	getUsableColumns(widget, columnList);
    	for (int i=0; i<columnList.size(); i++) {
    		UiPortalUserPreference preference = new UiPortalUserPreference();
			LayoutPanel column = columnList.get(i);
			LayoutPanel columnParent = (LayoutPanel) column.getParent();
    		preference.setAsColumnPreference(columnParent.getWidgetIndex(column));
			float width = -1;
			LayoutConstraints constraints = columnParent.getLayoutConstraints(column);
			if (constraints instanceof RowLayout.Constraints) {
				width = ((RowLayout.Constraints) constraints).getSize();
			}
			preference.setWidth(width);
    		list.add(preference);
    	}
    }
    
    private static void getGadgetPreferences(Widget widget, List<UiPortalUserPreference> list) {
    	if (widget instanceof Gadget) {
    		Gadget gadget = (Gadget) widget;
    		LayoutPanel column = (LayoutPanel) gadget.getParent();
    		LayoutPanel columnParent = (LayoutPanel) column.getParent();
    		
			UiPortalUserPreference preference = new UiPortalUserPreference();
			preference.setComponent(gadget.getComponent());
			preference.setKey(gadget.getPortletId());
			float width = -1;
			LayoutConstraints constraints = columnParent.getLayoutConstraints(column);
			if (constraints instanceof RowLayout.Constraints) {
				width = ((RowLayout.Constraints) constraints).getSize();
			}
			preference.setWidth(width);
			float height = -1;
			constraints = column.getLayoutConstraints(gadget);
			if (constraints instanceof RowLayout.Constraints) {
				height = ((RowLayout.Constraints) constraints).getSize();
			}
			preference.setHeight(height);
    		int rowIndex = column.getWidgetIndex(gadget);
			preference.setRowIndex(rowIndex);
    		int colIndex = columnParent.getWidgetIndex(column);
			preference.setColumnIndex(colIndex);
			list.add(preference);

    	} else if (widget instanceof IndexedPanel) {
    		int numChildren = ((IndexedPanel) widget).getWidgetCount();
    		for (int i=0; i<numChildren; i++) {
    			getGadgetPreferences(((IndexedPanel) widget).getWidget(i), list);
    		}
    	}
    }

    /**
     * Build list of columns that have at least a minimum width
     **/
    public static void getUsableColumns(Widget widget, List<ColumnPanel> list) {
    	ColumnSizingLayoutPanel columnParent = getColumnContainer(widget);
    	if (columnParent != null) {
			int numColumns = columnParent.getWidgetCount();
			for (int i=0; i<numColumns; i++) {
				ColumnPanel next = (ColumnPanel) columnParent.getWidget(i);
				if (next.getOffsetWidth() >= MIN_USABLE_COL_WIDTH) {
					list.add(next);
				}
			}
    	}
    }
    
    /**
     * Get the ColumnSizingLayoutPanel containing all the columns for Gadgets
     * This is specific to a single ColumnSizingLayoutPanel for all columns
     * @param root The root container
     * @return The ColumnSizingLayoutPanel
     */
    private static ColumnSizingLayoutPanel getColumnContainer(Widget root) {
    	if (root instanceof ColumnSizingLayoutPanel) {
    		return (ColumnSizingLayoutPanel) root;
    	} else if (root instanceof IndexedPanel) {
    		int numChildren = ((IndexedPanel) root).getWidgetCount();
    		for (int i=0; i<numChildren; i++) {
    			ColumnSizingLayoutPanel cLP = getColumnContainer(((IndexedPanel) root).getWidget(i));
   				if (cLP != null) {
   					return cLP;
    			}
    		}
    	}
    	return null;
    }

}
