/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLUtil {
    private SSLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(storeFormat);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(filePath);
            keyStore.load(fs, password.toCharArray());
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception ex) {}
            }
        }
        return keyStore;
    }

    public static KeyManagerFactory createKeyManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = SSLUtil.loadKeyStore(storeFormat, filePath, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, password.toCharArray());
        return keyManagerFactory;
    }

    public static TrustManagerFactory createTrustManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = SSLUtil.loadKeyStore(storeFormat, filePath, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }
}

