/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public class JBossJAASWebServiceFilter
extends BaseSecurityFilter {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.logger.info((Object)"init started...");
    }

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Basic")) {
            NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            if (principal == null) {
                this.logger.debug((Object)"Could not get Neptune Principal from Session");
                response.sendError(403, "Basic Authentication is not allowed from a remote component.");
                return;
            }
            String password = principal.getToken() != null ? principal.getToken() : "";
            this.logger.debug((Object)"Calling Neptune Login module");
            WebAuthentication webAuthentication = new WebAuthentication();
            if (!webAuthentication.login(principal.getUserName(), (Object)password)) {
                this.logger.error((Object)"WebAuthentication login failed!");
                response.sendError(401, "Wrong Username/Password.");
                return;
            }
        }
        this.logger.debug((Object)"Continuing with rest of the filters in the filter chain");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

