package com.tandbergtv.neptune.ui.realm.client.settings.view;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiBooleanSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

public class BooleanInputWidgetWrapper implements SettingsInputWidgetWrapper {
	
	protected CheckBoxWidget widget = null;
	private UiBooleanSetting setting;
	private String initialValue;
	private String settingName;
	
	@Override
	public Widget createInputWidget() {
		widget = new CheckBoxWidget();
		widget.setName(setting.getName());
		if (initialValue != null && !initialValue.isEmpty()) {
			widget.setValue(Boolean.valueOf(initialValue));	
		}
		widget.setTitle(setting.getName());
		
		return widget;
	}
	
	@Override
	public String getValue() {
		return widget.getValue().toString();
	}
	
	@Override
	public String getSettingName() {
		if (settingName == null) {
			return setting.getName();
		} else {
			return settingName;
		}
	}
	
	@Override
	public void setSettingName(String name) {
		this.settingName = name;
		if (widget != null) {
			widget.setTitle(name);
		}
	}

	@Override
	public SettingsInputWidgetWrapper newInstance() {
		return new BooleanInputWidgetWrapper();
	}

	@Override
	public void setInitialValue(String initialValue) {
		this.initialValue = initialValue;
	}

	@Override
	public void setSettingDefinition(UiSettingDefinition setting) {
		this.setting = (UiBooleanSetting) setting;
	}

	@Override
	public UiSettingDefinition getSettingDefinition() {
		return setting;
	}

}
