/*
 * Created on Dec 30, 2011
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Maintains the user configuration mode and related data
 * 
 * @author Vijay Silva
 */
public class UiUserConfiguration implements IsSerializable {

	/* The mode names */
	private static final String INTERNAL_MODE = "Internal";
	private static final String HYBRID_MODE = "Hybrid";
	private static final String EXTERNAL_MODE = "External";

	/* State */
	private String mode = INTERNAL_MODE;
	private boolean userNameSortable = false;
	private boolean firstNameSortable = false;
	private boolean lastNameSortable = false;
	private boolean createInternalUserAllowed = false;

	/**
	 * Constructor
	 */
	public UiUserConfiguration() {
	}

	/**
	 * Determine if the mode is the internal mode
	 * 
	 * @return true if internal mode, false otherwise
	 */
	public boolean isInternalMode() {
		return INTERNAL_MODE.equals(mode);
	}

	/**
	 * Set the mode as the internal mode
	 */
	public void setInternalMode() {
		this.mode = INTERNAL_MODE;
	}

	/**
	 * Determine if the mode is the hybrid mode
	 * 
	 * @return true if hybrid mode, false otherwise
	 */
	public boolean isHybridMode() {
		return HYBRID_MODE.equals(mode);
	}

	/**
	 * Set the mode as the hybrid mode
	 */
	public void setHybridMode() {
		this.mode = HYBRID_MODE;
	}

	/**
	 * Determine if the mode is the hybrid mode
	 * 
	 * @return true if hybrid mode, false otherwise
	 */
	public boolean isExternalMode() {
		return EXTERNAL_MODE.equals(mode);
	}

	/**
	 * Set the mode as the external mode
	 */
	public void setExternalMode() {
		this.mode = EXTERNAL_MODE;
	}

	/**
	 * Determine if the external user name field supports sorting
	 * 
	 * @return flag indicating that the external user name field can be sorted
	 */
	public boolean isUserNameSortable() {
		return this.userNameSortable;
	}

	/**
	 * Set if the external user name field supports sorting
	 * 
	 * @param sortable flag indicating that external user name field can be sorted
	 */
	public void setUserNameSortable(boolean sortable) {
		this.userNameSortable = sortable;
	}

	/**
	 * Determine if the external user first name field supports sorting
	 * 
	 * @return flag indicating that the external user first name field can be sorted
	 */
	public boolean isFirstNameSortable() {
		return this.firstNameSortable;
	}

	/**
	 * Set if the external user name field supports sorting
	 * 
	 * @param sortable flag indicating that external user first name field can be sorted
	 */
	public void setFirstNameSortable(boolean sortable) {
		this.firstNameSortable = sortable;
	}

	/**
	 * Determine if the external user last name field supports sorting
	 * 
	 * @return flag indicating that the external user last name field can be sorted
	 */
	public boolean isLastNameSortable() {
		return this.lastNameSortable;
	}

	/**
	 * Set if the external user last name field supports sorting
	 * 
	 * @param sortable flag indicating that external user last name field can be sorted
	 */
	public void setLastNameSortable(boolean sortable) {
		this.lastNameSortable = sortable;
	}

	/**
	 * Determine if the application is allowed to create internal users
	 * 
	 * @return true if allowed to create internal users, false otherwise
	 */
	public boolean isCreateInternalUserAllowed() {
		return createInternalUserAllowed;
	}

	/**
	 * Set the create internal user flag. This is ignored if the mode is internal.
	 * 
	 * @param allowed true to allow creating internal users, false otherwise.
	 */
	public void setCreateInternalUserAllowed(boolean allowed) {
		this.createInternalUserAllowed = allowed;
	}
}
