/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * View commit event indicating the user has triggered the commit action in a view which has
 * successfully completed
 * 
 * @author Vijay Silva
 */
public class ViewCommitEvent<T> extends GwtEvent<ViewCommitHandler<T>> {

	/* The Handler type */
	private static Type<ViewCommitHandler<?>> TYPE;
	private T data;

	/**
	 * Constructor
	 * 
	 * @param data The data
	 */
	public ViewCommitEvent(T data) {
		this.data = data;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ViewCommitHandler<?>> getType() {
		if (TYPE == null) {
			TYPE = new Type<ViewCommitHandler<?>>();
		}

		return TYPE;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Type<ViewCommitHandler<T>> getAssociatedType() {
		return (Type) TYPE;
	}

	@Override
	protected void dispatch(ViewCommitHandler<T> handler) {
		handler.onCommit(this);
	}

	/**
	 * Get the committed data
	 * 
	 * @return The committed data
	 */
	public T getData() {
		return data;
	}
}
