/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.settings.ejb;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.configuration.service.INeptuneSettingChangeListener;
import com.tandbergtv.neptune.configuration.service.INeptuneUpgradeSettings;
import com.tandbergtv.neptune.configuration.service.JSONToMapConverter;
import com.tandbergtv.neptune.configuration.service.SettingToJSONConverter;
import com.tandbergtv.neptune.configuration.settings.entity.ComplexSetting;
import com.tandbergtv.neptune.configuration.settings.entity.ObjectFactory;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.Settings;
import com.tandbergtv.neptune.configuration.settings.entity.StringSetting;
import com.tandbergtv.neptune.configuration.settings.entity.UpgradeSettingType;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.configuration.settings.util.ValidationMessageHelper;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import com.tandbergtv.neptune.configuration.validation.SettingsValidatorFactory;
import com.tandbergtv.neptune.configuration.validation.SettingsValidatorService;
import com.tandbergtv.neptune.configuration.validation.ValidationGroup;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.licensing.LicenseManager;
import com.tandbergtv.neptune.realm.persist.Setting;
import com.tandbergtv.neptune.realm.persist.SettingGroup;
import com.tandbergtv.neptune.settings.cache.SettingsCache;
import com.tandbergtv.neptune.settings.ejb.SettingsConfigurationLoaderFactory;
import com.tandbergtv.neptune.settings.ejb.SettingsConfigurationLocator;
import com.tandbergtv.neptune.settings.ejb.dao.SettingsDefinitionDAO;
import com.tandbergtv.neptune.validation.SettingValidationException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

@Stateless
@Local(value={ISettingsService.class})
public class SettingsService
implements ISettingsService {
    public static final String SETTING_PATH_SEPARATOR = ".";
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    @Resource
    private SessionContext ctx;
    @EJB
    private IAuthorizationService authorizationService;
    private SettingsConfigurationLoaderFactory settingsConfigurationLoaderFactory;
    private SettingsDefinitionDAO settingsDefinitionDAO;
    private LicenseManager licenseManager;
    private SettingsCache settingsCache;
    private static final String NEPTUNE_SETTINGS_XSD = "neptuneSettings.xsd";
    private static final Logger logger = Logger.getLogger(SettingsService.class);

    public void loadSettings(String confFolderLocation) {
        List<SettingsConfigurationLocator> settingLocators = this.getSettingsConfigurationLoaderFactory().createSettingConfigurationLocators(confFolderLocation);
        ArrayList<URL> configFiles = new ArrayList<URL>();
        for (SettingsConfigurationLocator settingLocator : settingLocators) {
            configFiles.addAll(settingLocator.findSettingsConfigurations());
        }
        Unmarshaller umarshaller = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            umarshaller = jc.createUnmarshaller();
            URL schemaUrl = SettingsService.class.getResource(NEPTUNE_SETTINGS_XSD);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            umarshaller.setSchema(schema);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating parser for settings.", (Throwable)e);
        }
        ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> allSettings = new ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>();
        for (URL cfg : configFiles) {
            if (umarshaller == null) continue;
            try {
                JAXBElement result = umarshaller.unmarshal((Source)new StreamSource(cfg.openStream()), Settings.class);
                allSettings.addAll(((Settings)result.getValue()).getSettingGroups());
            }
            catch (Exception x) {
                logger.error((Object)("Error while loading settings for file: " + cfg.toExternalForm()), (Throwable)x);
            }
        }
        this.saveSettingDefinitions(allSettings, confFolderLocation);
    }

    private SettingsConfigurationLoaderFactory getSettingsConfigurationLoaderFactory() {
        if (this.settingsConfigurationLoaderFactory == null) {
            this.settingsConfigurationLoaderFactory = new SettingsConfigurationLoaderFactory();
        }
        return this.settingsConfigurationLoaderFactory;
    }

    private SettingsDefinitionDAO getSettingsDefinitionDAO() {
        if (this.settingsDefinitionDAO == null) {
            this.settingsDefinitionDAO = SettingsDefinitionDAO.getInstance();
        }
        return this.settingsDefinitionDAO;
    }

    private SettingsCache getSettingsCache() {
        if (this.settingsCache == null) {
            this.settingsCache = SettingsCache.getInstance();
        }
        return this.settingsCache;
    }

    private List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> filterLicensedSettings(List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> settings, String confFolderLocation) {
        HashMap<String, com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> filteredGroups = new HashMap<String, com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>(settings.size());
        HashMap<String, List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>> groupsChildren = new HashMap<String, List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>>(settings.size());
        for (com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group : settings) {
            filteredGroups.put(group.getPath(), group);
            if (group.getParentPath() == null || group.getParentPath().isEmpty()) continue;
            ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> children = (ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>)groupsChildren.get(group.getParentPath());
            if (children == null) {
                children = new ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>();
                groupsChildren.put(group.getParentPath(), children);
            }
            children.add(group);
        }
        try {
            Properties licensedComponents = this.getLicenseManager().getProperties(new File(confFolderLocation));
            block5: for (com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group : settings) {
                if (group.getRequiredLicenses() == null || group.getRequiredLicenses().isEmpty()) continue;
                String[] licenses = group.getRequiredLicenses().split(",");
                boolean isLicensed = false;
                for (String settingLicense : licenses) {
                    String componentLicense = licensedComponents.getProperty(settingLicense);
                    if (componentLicense != null) {
                        if (Boolean.valueOf(componentLicense).booleanValue()) {
                            isLicensed = true;
                        } else {
                            try {
                                int number = Integer.parseInt(componentLicense);
                                if (number > 0) {
                                    isLicensed = true;
                                }
                            }
                            catch (NumberFormatException n) {
                                // empty catch block
                            }
                        }
                    }
                    if (isLicensed) continue;
                    logger.debug((Object)("License not found for setting group: " + group.getPath()));
                    this.removeGroupAndChildren(filteredGroups, groupsChildren, group);
                    continue block5;
                }
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)"Couldn't validate settings licenses.", (Throwable)e);
        }
        return new ArrayList<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>(filteredGroups.values());
    }

    private LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = new LicenseManager();
        }
        return this.licenseManager;
    }

    private void removeGroupAndChildren(Map<String, com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> allGroups, Map<String, List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup>> groupsChildren, com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group) {
        allGroups.remove(group.getPath());
        List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> children = groupsChildren.get(group.getPath());
        if (children != null) {
            for (com.tandbergtv.neptune.configuration.settings.entity.SettingGroup child : children) {
                this.removeGroupAndChildren(allGroups, groupsChildren, child);
            }
        }
    }

    public Collection<Setting> findSettingsByGroup(String settingsPath) {
        Query query = this.entityManager.createNamedQuery("Setting.FindAllByGroup");
        query.setParameter("path", (Object)settingsPath);
        List settings = query.getResultList();
        return settings;
    }

    public void saveSettingDefinitions(List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> settings, String confFolderLocation) {
        settings = this.filterLicensedSettings(settings, confFolderLocation);
        this.getSettingsDefinitionDAO().saveSettingDefinitions(settings);
        for (com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group : settings) {
            SettingGroup persistedGroup = this.synchGroup(group);
            for (SettingDefinition settingDefinition : group.getSettings()) {
                if (settingDefinition instanceof ComplexSetting) {
                    ComplexSetting complex = (ComplexSetting)settingDefinition;
                    if (complex.getDefaultValue() == null) continue;
                    try {
                        if (!this.findSettingsByGroup(group.getPath()).isEmpty()) continue;
                        JsonNode node = new ObjectMapper().readTree(complex.getDefaultValue());
                        Map values = new JSONToMapConverter(node).convert();
                        for (String settingName : values.keySet()) {
                            this.synchSettings(settingName, values.get(settingName), persistedGroup);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error loading JSON default value for setting: " + complex.getName() + " JSON: " + complex.getDefaultValue()), (Throwable)e);
                        continue;
                    }
                }
                this.synchSimpleSettings(settingDefinition, persistedGroup);
            }
            UpgradeSettingType upgrade = group.getUpgrade();
            if (upgrade != null) {
                if (upgrade.getUpgradeClass() != null) {
                    this.upgradeSettings(upgrade.getFileName(), group.getPath(), upgrade.getUpgradeClass(), confFolderLocation);
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"UPGRADE CLASS FILE NOT DEFINED !! ");
                }
            }
            this.validateSettingGroup(group.getPath());
        }
    }

    private void upgradeSettings(String upgradeFilePath, String groupPath, String upgradeClass, String confFolderLocation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UPGRADING SETTINGS ACCORDING TO FILE : " + upgradeFilePath));
            logger.debug((Object)("INVOKING UPGRADING SETTINGS CLASS : " + upgradeClass));
        }
        INeptuneUpgradeSettings upgradeClassInstance = null;
        Map upgradeValues = null;
        try {
            Class<?> neptuneUpgradeService = Thread.currentThread().getContextClassLoader().loadClass(upgradeClass);
            upgradeClassInstance = (INeptuneUpgradeSettings)neptuneUpgradeService.newInstance();
            upgradeClassInstance.setFileName(upgradeFilePath);
            upgradeClassInstance.setCMSBaseConfFolder(confFolderLocation);
            if (upgradeClassInstance.needsUpgrade()) {
                upgradeValues = upgradeClassInstance.upgrade();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("ERROR ON UPGRADE SETTINGS: Can't found class " + upgradeClass + " : " + e.getMessage()));
        }
        catch (Exception ex) {
            logger.error((Object)("ERROR ON UPGRADE SETTINGS CLASS EXECUTION: class " + upgradeClass + " : " + ex.getMessage()));
        }
        if (upgradeValues != null) {
            try {
                this.saveSettings(groupPath, upgradeValues, true);
                upgradeClassInstance.upgradeApplied();
            }
            catch (SettingValidationException e) {
                logger.error((Object)"ERROR ON UPGRADE SETTINGS saveSettings() method : ");
                logger.error((Object)("saveSettings() method ERROR : " + ValidationMessageHelper.formatErrorMessages((List)e.getValidationErrors()).toString()));
            }
            catch (Exception ex) {
                logger.error((Object)("ERROR ON UPGRADE SETTINGS saveSettings() method:  : " + ex.getMessage()));
            }
        }
    }

    private SettingGroup synchGroup(com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group) {
        SettingGroup persistedGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("SettingGroup.FindByPath");
            query.setParameter("path", (Object)group.getPath());
            persistedGroup = (SettingGroup)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        if (persistedGroup == null) {
            persistedGroup = new SettingGroup();
            persistedGroup.setPath(group.getPath());
            persistedGroup.setParentPath(group.getParentPath());
            this.entityManager.persist((Object)persistedGroup);
        }
        this.getSettingsCache().cacheGroup(persistedGroup);
        return persistedGroup;
    }

    private void synchSimpleSettings(SettingDefinition definition, SettingGroup persistedGroup) {
        Setting persistedSetting = this.getSettingFromDB(persistedGroup.getPath(), definition.getName());
        if (persistedSetting == null) {
            persistedSetting = new Setting();
            persistedSetting.setName(definition.getName());
            String value = this.getValue(definition);
            if (value != null) {
                persistedSetting.setValue(value);
            }
            persistedSetting.setGroup(persistedGroup);
            persistedSetting.setCreateDate(new Date());
            persistedSetting.setUpdateDate(persistedSetting.getCreateDate());
            this.entityManager.persist((Object)persistedSetting);
        }
        this.getSettingsCache().cacheSetting(persistedSetting);
    }

    private Setting getSettingFromDB(String path, String name) {
        Query query = this.entityManager.createNamedQuery("Setting.FindByName");
        query.setParameter("path", (Object)path);
        query.setParameter("name", (Object)name);
        try {
            return (Setting)query.getSingleResult();
        }
        catch (NoResultException n) {
            logger.warn((Object)("Cannot find property[group:" + path + ", name:" + name + "] in DB"));
            return null;
        }
    }

    private String getValue(SettingDefinition definition) {
        if (definition.getFrom() == null || "".equals(definition.getFrom().trim())) {
            return this.getDefaultValue(definition);
        }
        String[] paths = definition.getFrom().split("/");
        if (paths.length != 2) {
            logger.warn((Object)("Invalid setting path defined in From element: " + definition.getFrom() + ", use default value"));
            return this.getDefaultValue(definition);
        }
        Setting originalValue = this.getSettingFromDB(paths[0], paths[1]);
        if (originalValue == null) {
            return this.getDefaultValue(definition);
        }
        if (!this.validateSimpleProperty(definition, originalValue.getValue())) {
            return this.getDefaultValue(definition);
        }
        return originalValue.getValue();
    }

    private boolean validateSimpleProperty(SettingDefinition definition, String value) {
        List<Class<? extends SettingValidator>> validators = SettingsValidatorFactory.getInstance().getValidatorsFor(definition);
        if (validators == null) {
            return true;
        }
        boolean isValid = true;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (Class<? extends SettingValidator> validatorClass : validators) {
            SettingValidator validator = null;
            try {
                validator = validatorClass.newInstance();
                ValidationResult result = validator.validate(definition, value);
                isValid &= result.hasSucceed();
                results.add(result);
            }
            catch (Exception e) {
                logger.warn((Object)("Skip due to error when validating value[" + value + "] against " + validatorClass.getCanonicalName()), (Throwable)e);
            }
        }
        if (!isValid) {
            logger.warn((Object)("value[" + value + "] from " + definition.getFrom() + " is not valid for property [" + definition.getName() + "], error message[" + ValidationMessageHelper.formatErrorMessages(results) + "]"));
        }
        return isValid;
    }

    private String getDefaultValue(SettingDefinition definition) {
        return definition.getDefaultValue() == null ? null : String.valueOf(definition.getDefaultValue());
    }

    private void synchSettings(String settingName, Object defaultValue, SettingGroup persistedGroup) {
        Query query = this.entityManager.createNamedQuery("Setting.FindByName");
        query.setParameter("path", (Object)persistedGroup.getPath());
        query.setParameter("name", (Object)settingName);
        Setting persistedSetting = null;
        try {
            persistedSetting = (Setting)query.getSingleResult();
        }
        catch (NoResultException n) {
            // empty catch block
        }
        if (persistedSetting == null) {
            persistedSetting = new Setting();
            persistedSetting.setCreateDate(new Date());
            persistedSetting.setUpdateDate(persistedSetting.getCreateDate());
            persistedSetting.setName(settingName);
            if (defaultValue != null) {
                persistedSetting.setValue(defaultValue.toString());
            }
            persistedSetting.setGroup(persistedGroup);
            this.entityManager.persist((Object)persistedSetting);
        }
        this.getSettingsCache().cacheSetting(persistedSetting);
    }

    public Map<String, String> getProperties(String settingsPath) {
        Map<String, String> map = this.getSettingsCache().readSettingsFromCache(settingsPath);
        if (map != null && map.size() > 0) {
            return map;
        }
        logger.debug((Object)("Settings for " + settingsPath + " were expected to be found in cache. Since cache returned null, checking the DB..."));
        Collection<Setting> settings = this.findSettingsByGroup(settingsPath);
        map = new HashMap<String, String>(settings.size());
        for (Setting setting : settings) {
            String value = setting.getValue();
            if (value == null) {
                value = "";
            }
            map.put(setting.getName(), value);
            this.getSettingsCache().cacheSetting(setting);
        }
        return map;
    }

    public void saveSettings(String groupPath, Map<String, String> values, boolean ignoreValidation) throws SettingValidationException {
        List<ValidationResult> errors;
        com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group = this.getSettingsDefinitionDAO().getSettingDefinitionsForGroup(groupPath);
        if (group == null) {
            ValidationResult result = new ValidationResult();
            result.fail().addMessage("SettingGroup " + groupPath + " doesn't exists.", "en");
            throw new SettingValidationException(result);
        }
        if (values == null) {
            ValidationResult result = new ValidationResult();
            result.fail().addMessage("There is no Settings to be saved for GroupPath " + groupPath + " .", "en");
            throw new SettingValidationException(result);
        }
        this.trimNonStringValues(group, values);
        boolean isComplexGroup = false;
        if (!group.getSettings().isEmpty() && group.getSettings().get(0) instanceof ComplexSetting) {
            isComplexGroup = true;
        }
        boolean hasChangedSaved = false;
        if (!ignoreValidation && !(errors = this.validateSettings(group, values)).isEmpty()) {
            throw new SettingValidationException(errors);
        }
        Collection<Setting> settings = this.findSettingsByGroup(groupPath);
        for (Setting setting : settings) {
            if (values.containsKey(setting.getName())) {
                boolean hasChanged;
                String newValue = values.get(setting.getName());
                String currentValue = setting.getValue();
                if (setting.getValue() == null) {
                    currentValue = "";
                }
                if (newValue == null) {
                    newValue = "";
                }
                boolean bl = hasChanged = !newValue.equals(currentValue);
                if (hasChanged) {
                    setting.setValue(values.get(setting.getName()));
                    setting.setUpdateDate(new Date());
                    this.entityManager.merge((Object)setting);
                    try {
                        this.entityManager.flush();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception while doing flush() : " + e.getMessage()));
                        e.printStackTrace();
                    }
                    this.getSettingsCache().cacheSetting(setting);
                    this.audit("UPDATE", " -SETTING- " + setting.getName() + " -HAS VALUE- " + currentValue + " -- CHANGED TO: " + setting.getValue());
                    hasChangedSaved = true;
                }
                values.remove(setting.getName());
                continue;
            }
            if (!isComplexGroup) continue;
            this.entityManager.remove((Object)setting);
            this.getSettingsCache().removeSettingCache(setting);
            this.audit("DELETE", " -SETTING- " + setting.getName() + " -WITH VALUE- " + setting.getValue());
            hasChangedSaved = true;
        }
        SettingGroup persistedGroup = null;
        try {
            Query query = this.entityManager.createNamedQuery("SettingGroup.FindByPath");
            query.setParameter("path", (Object)group.getPath());
            persistedGroup = (SettingGroup)query.getSingleResult();
        }
        catch (NoResultException n) {
            // empty catch block
        }
        for (String settingName : values.keySet()) {
            Setting persistedSetting = new Setting();
            persistedSetting.setCreateDate(new Date());
            persistedSetting.setUpdateDate(persistedSetting.getCreateDate());
            persistedSetting.setName(settingName);
            persistedSetting.setValue(values.get(settingName));
            persistedSetting.setGroup(persistedGroup);
            this.entityManager.persist((Object)persistedSetting);
            this.getSettingsCache().cacheSetting(persistedSetting);
            this.audit("CREATE", " -SETTING- " + persistedSetting.getName() + " -WITH VALUE- " + persistedSetting.getValue());
            hasChangedSaved = true;
        }
        if (group.getChangeSettingsNotificationClass() != null && hasChangedSaved) {
            try {
                Class<?> neptuneSettingChangeListener = Thread.currentThread().getContextClassLoader().loadClass(group.getChangeSettingsNotificationClass());
                INeptuneSettingChangeListener listener = (INeptuneSettingChangeListener)neptuneSettingChangeListener.newInstance();
                listener.settingsChanged(this.getProperties(groupPath));
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("Can't found class " + group.getChangeSettingsNotificationClass() + " : " + e.getMessage()));
            }
            catch (Exception ex) {
                logger.error((Object)("Error on executing class " + group.getChangeSettingsNotificationClass() + " : " + ex.getMessage()));
            }
        }
        this.getSettingsCache().publishSettingsUpdate(group.getPath());
        this.validateSettingGroup(group.getPath());
    }

    public void saveSettings(String groupPath, Map<String, String> values) throws SettingValidationException {
        this.saveSettings(groupPath, values, false);
    }

    public void importAllSettings(Map<String, Map<String, String>> settings, boolean ingoreValidation) throws SettingValidationException {
        Set<String> paths = settings.keySet();
        for (String groupPath : paths) {
            Map<String, String> values = settings.get(groupPath);
            try {
                this.saveSettings(groupPath, values, ingoreValidation);
            }
            catch (SettingValidationException e) {
                logger.error((Object)("ERROR on saving settings to DB: " + e.getMessage()));
                this.ctx.setRollbackOnly();
                throw e;
            }
        }
    }

    protected List<ValidationResult> validateSettings(com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group, Map<String, String> values) {
        SettingsValidatorService validationService = new SettingsValidatorService();
        List<ValidationResult> errors = validationService.validateSettings(group, values);
        return errors;
    }

    public List<ValidationResult> validateSettingGroup(String groupPath) {
        SettingsValidatorService validationService = new SettingsValidatorService(ValidationGroup.SIMPLE_GROUP_UNDEFINED_SETTINGS);
        List<ValidationResult> validationMessages = validationService.validateSettings(this.getSettingsDefinitionDAO().getSettingDefinitionsForGroup(groupPath), this.getProperties(groupPath));
        if (!validationMessages.isEmpty()) {
            this.getSettingsDefinitionDAO().setGroupWithErrors(groupPath);
        } else {
            this.getSettingsDefinitionDAO().clearGroupErrors(groupPath);
        }
        return validationMessages;
    }

    public Set<String> getInconsistentSettingGroupList() {
        return this.getSettingsDefinitionDAO().getGroupsWithErrors();
    }

    public List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> getAllSettingDefinitions() {
        return this.getSettingsDefinitionDAO().getAllSettingDefinitions();
    }

    public List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> findSettingDefinitions(String filter) {
        return this.getSettingsDefinitionDAO().findSettingDefinitions(filter);
    }

    public String getPropertiesAsJSON(String settingsPath) {
        com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group = this.getSettingsDefinitionDAO().getSettingDefinitionsForGroup(settingsPath);
        if (group != null) {
            ObjectNode root = new SettingToJSONConverter(group, this.getProperties(settingsPath)).convert();
            return root.toString();
        }
        return null;
    }

    public String getAllSettingDefinitionsAsJSON() {
        String seetingGroupsAsJSON = null;
        HashMap settingGroupsJSON = new HashMap();
        ArrayList settingGrouplist = new ArrayList();
        List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> settingGroups = this.getAllSettingDefinitions();
        for (com.tandbergtv.neptune.configuration.settings.entity.SettingGroup settingGroup : settingGroups) {
            String jsonProperties = this.getPropertiesAsJSON(settingGroup.getPath());
            HashMap<String, String> settingsJSON = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> settingGroupJSON = new HashMap<String, HashMap<String, String>>();
            settingsJSON.put("path", settingGroup.getPath());
            settingGroupJSON.put("settingGroup", settingsJSON);
            settingsJSON.put("settings", jsonProperties);
            settingGrouplist.add(settingGroupJSON);
        }
        settingGroupsJSON.put("settingGroups", settingGrouplist);
        ObjectMapper mapper = new ObjectMapper();
        try {
            seetingGroupsAsJSON = mapper.writeValueAsString(settingGroupsJSON);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return seetingGroupsAsJSON;
    }

    public void saveSingleSetting(String groupPath, String setting, String value) throws SettingValidationException {
        Map<String, String> groupSettings = this.getProperties(groupPath);
        groupSettings.put(setting, value);
        this.saveSettings(groupPath, groupSettings);
    }

    private void audit(String action, String message) {
        String userName = this.authorizationService.getUserName();
        logger.info((Object)("SETTING ACTION: " + action + " -- " + " DONE BY USER: " + userName + " ====>MESSAGE: " + message));
    }

    private void trimNonStringValues(com.tandbergtv.neptune.configuration.settings.entity.SettingGroup group, Map<String, String> values) {
        for (SettingDefinition def : group.getSettings()) {
            this.trimNonStringValues("", def, values);
        }
    }

    private void trimNonStringValues(String parentPath, SettingDefinition def, Map<String, String> values) {
        String value;
        String currentPath = def.getName();
        if (!parentPath.isEmpty()) {
            currentPath = parentPath + SETTING_PATH_SEPARATOR + currentPath;
        }
        if (def instanceof ComplexSetting) {
            ComplexSetting complex = (ComplexSetting)def;
            boolean isArray = complex.getMax() == null || complex.getMax() > 1;
            boolean bl = isArray = !parentPath.isEmpty() && isArray;
            if (isArray) {
                int arrayLength = -1;
                String arrayStart = currentPath + "[";
                for (String key : values.keySet()) {
                    if (!key.startsWith(arrayStart)) continue;
                    int arrayCloseIndex = key.indexOf("]", arrayStart.length());
                    String currentIndexStr = key.substring(arrayStart.length(), arrayCloseIndex);
                    int currentIndex = Integer.parseInt(currentIndexStr);
                    if (currentIndex <= arrayLength) continue;
                    arrayLength = currentIndex;
                }
                if (arrayLength >= 0) {
                    for (int i = 0; i <= arrayLength; ++i) {
                        for (SettingDefinition sub : complex.getSettings()) {
                            String currentIndexedPath = currentPath + "[" + i + "]";
                            this.trimNonStringValues(currentIndexedPath, sub, values);
                        }
                    }
                }
            } else {
                for (SettingDefinition sub : complex.getSettings()) {
                    this.trimNonStringValues(currentPath, sub, values);
                }
            }
        } else if (values.containsKey(currentPath) && !(def instanceof StringSetting) && (value = values.get(currentPath)) != null) {
            values.put(currentPath, value.trim());
        }
    }

    public List<com.tandbergtv.neptune.configuration.settings.entity.SettingGroup> findSettingDefinitionsByParentPath(String filter) {
        return this.getSettingsDefinitionDAO().findSettingDefinitionsByParentPath(filter);
    }
}

