/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.SettingGroup;
import com.tandbergtv.neptune.configuration.settings.validator.GroupValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SimpleSettingsValidator
implements GroupValidator {
    @Override
    public List<ValidationResult> validate(SettingGroup group, Map<String, String> values) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>();
        HashSet<String> validSettings = new HashSet<String>(group.getSettings().size());
        for (SettingDefinition def : group.getSettings()) {
            validSettings.add(def.getName());
        }
        for (String settingToBeSaved : values.keySet()) {
            if (validSettings.contains(settingToBeSaved)) continue;
            ValidationResult result = new ValidationResult();
            ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(2);
            ArrayList<LocalizedString> settingToBeInserted = new ArrayList<LocalizedString>(1);
            settingToBeInserted.add(new LocalizedString(settingToBeSaved, "en"));
            params.add(settingToBeInserted);
            params.add(group.getDisplayName());
            result.fail().addMessage("Setting {0} does not belong to the {1} component. ", "en", params);
            errors.add(result);
        }
        return errors;
    }
}

