/*
 * Created on Jan 4, 2012
 * 
 * (C) Copyright Ericsson Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.i18n;

import com.google.gwt.i18n.client.Messages;

/**
 * Messages used by the realm component
 * 
 * @author Vijay Silva
 */
public interface RealmMessages extends Messages {

	/* Error getting a user record by key */
	String getUserFailure(@Optional String userId, String errorMessage);

	/* Error deleting the selected users */
	String getUserByNameFailure(@Optional String userName, String errorMessage);

	/* Get the heading for the user edit screen */
	String userEditHeading(String userName);
	
	/* Error deleting users */
	String deleteUsersFailure(String errorMessage);

	/* Error message getting the external user record */
	String getExternalUserFailure(@Optional String externalKey, String errorMessage);

	/* Error message when creating an external user that is already created */
	String externalUserCreated(@Optional String userName);

	/* Error getting the user configuration data */
	String getUserConfigurationFailure(String errorMessage);
}
