package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable;

import java.util.ArrayList;
import java.util.List;

public class TableRow {

	private boolean checked = false;
	private List<String> colName;
	private List<String> colData;

	/**
	 * Constructor that takes in all the column names and boolean if row has
	 * been checked
	 * 
	 * @param colName
	 * @param checked
	 */
	public TableRow(List<String> colName, boolean checked) {
		this.colData = new ArrayList<String>();
		this.colName = colName;
		this.checked = checked;
	}

	/**
	 * Checked?
	 * 
	 * @return
	 */
	public boolean isChecked() {
		return checked;
	}

	/**
	 * Add a value to the corresponding column
	 * 
	 * @param name
	 * @param value
	 */
	public void setValue(String name, String value) {
		int colIndex = colName.indexOf(name);
		colData.add(colIndex, value);
	}

	/**
	 * Get value of corresponding column
	 * 
	 * @param name
	 * @return
	 */
	public String getValue(String name) {
		return colData.get(colName.indexOf(name));
	}

	/**
	 * Get number of columns for this particular row
	 * 
	 * @return
	 */
	public int getColumnCount() {
		return colName.size();
	}
}
