package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label;

public class LabelEllipsedView extends LabelView<String> {
	
	public static final String STRING_CONTINUATION = "...";
	
	public LabelEllipsedView(String value, int maxLength) {
		super(value);
		String shortenedStr = value;
		if (shortenedStr != null && shortenedStr.length() > maxLength) {
			shortenedStr = shortenedStr.substring(0, maxLength - STRING_CONTINUATION.length()) 
					+ STRING_CONTINUATION;
		}

		label.setText(shortenedStr);
	}

	@Override
	protected String getViewValue() {
		return label.getText();
	}

	@Override
	protected void setViewValue(String data) {
		label.setTitle(data);
	}
	
	
}
