package com.tandbergtv.neptune.ui.componentmgr.client.tab.component.view;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.ui.componentmgr.client.tab.component.view.ComponentTableViewEventHandler;

/**
 * Component Table View event indicating that the component table view has triggered an event
 * 
 */
class ComponentTableViewEvent extends GwtEvent<ComponentTableViewEventHandler> {

	/* The handler type */
	private final EventType eventType;
	private static Type<ComponentTableViewEventHandler> TYPE;

	/**
	 * Constructor
	 * 
	 * @param eventType The event type
	 */
	public ComponentTableViewEvent(EventType eventType) {
		this.eventType = eventType;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<ComponentTableViewEventHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<ComponentTableViewEventHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<ComponentTableViewEventHandler> getAssociatedType() {
		return getType();
	}

	/*
	 * Fire the event
	 */
	@Override
	protected void dispatch(ComponentTableViewEventHandler handler) {
		if (eventType == null)
			return;

		switch (eventType) {
		case CREATE:
			handler.onCreateButtonClick(this);
			break;
		case DELETE:
			handler.onDeleteButtonClick(this);
			break;
		}
	}

	/**
	 * The event types
	 */
	static enum EventType {
		CREATE, DELETE;
	}
}
