package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

/**
 * A builder to create toast window.
 * @author ehanrli
 *
 */
public class ToastWindowBuilder {
	
	private ToastWindow toast = null;
	
	/**
	 * A builder to create toast window.
	 */
	public ToastWindowBuilder() {
		toast = new ToastWindow();
	}
	
	/**
	 * show it ini middle
	 * @return
	 */
	public ToastWindowBuilder middle() {
		toast.setPositionInMiddle();
		return this;
	}
	
	/**
	 * don't use icon in close button to avoid the server is restarting, the image is not ready.
	 * 
	 * @param message
	 * @param delayToClose
	 */

	public ToastWindowBuilder warning(String message, int delayToClose){
		toast.buildToast(message, delayToClose, "ebNotification_color_yellow", "ebIcon_txt_close_yellow");
		return this;
	}
	
	public ToastWindowBuilder info(String message, int delayToClose){
		toast.buildToast(message, delayToClose, "ebNotification_color_paleBlue", "ebIcon_txt_close_paleBlue");
		return this;
	}
	
	public ToastWindowBuilder error(String message, int delayToClose){
		toast.buildToast(message, delayToClose, "ebNotification_color_red", "ebIcon_txt_close_red");
		return this;
	}
	
	public ToastWindowBuilder delayToClose(int delayToClose){
		toast.setDelayToClose(delayToClose);
		return this;
	}

	
	public ToastWindow show() {
		toast.show();
		return toast;
	}
}
