/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.filter.BaseSecurityFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClientLoggingFilter
extends BaseSecurityFilter {
    private Logger logger = Logger.getLogger(ClientLoggingFilter.class);
    private static final String METHODS = "methods_allowed";
    private Map<Pattern, List<String>> allowedMethods;

    @Override
    public void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String fingerPrint = request.getHeader("X-SSL-Client-FINGERPRINT");
        if (StringUtils.isBlank((String)fingerPrint) && this.isMethodLoggingRequired(request)) {
            NeptunePrincipal principal = (NeptunePrincipal)request.getAttribute("neptune_sso_oauth2_principal");
            String remoteIp = request.getRemoteAddr();
            String ipAddresses = request.getHeader("X-Forwarded-For");
            StringBuilder Log = new StringBuilder();
            if (principal != null) {
                Log.append("[User access] " + principal.getUserName() + " has made a webservice call from User IP address(s):" + remoteIp);
                if (ipAddresses != null) {
                    Log.append("," + ipAddresses);
                }
                Log.append(" - URL:" + request.getRequestURI() + " - Method:" + request.getMethod());
                this.logger.info((Object)Log.toString());
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isMethodLoggingRequired(HttpServletRequest request) {
        Set<Pattern> keySet = this.allowedMethods.keySet();
        for (Pattern key : keySet) {
            if (!this.isMatching(request, key)) continue;
            return this.allowedMethods.get(key).contains(request.getMethod());
        }
        return true;
    }

    private boolean isMatching(HttpServletRequest request, Pattern p) throws PatternSyntaxException {
        Matcher m = p.matcher(request.getRequestURI());
        return m.find();
    }

    @Override
    public void loadConfiguration(FilterConfig config) throws ServletException {
        this.allowedMethods = this.readMethods(config.getInitParameter(METHODS));
    }

    private ConcurrentHashMap<Pattern, List<String>> readMethods(String initParameter) {
        ConcurrentHashMap<Pattern, List<String>> urlMethodMap = new ConcurrentHashMap<Pattern, List<String>>();
        if (this.isEmpty(initParameter)) {
            return new ConcurrentHashMap<Pattern, List<String>>();
        }
        String[] urlMethodsString = initParameter.split("\\|");
        if (urlMethodsString != null) {
            for (String urlMethods : urlMethodsString) {
                String[] methodList;
                if (this.isEmpty(urlMethods) || (methodList = (urlMethods = urlMethods.trim()).split(":")) == null || this.isEmpty(methodList[1])) continue;
                String methods = methodList[1].replaceAll("\\s", "");
                methods = methods.toUpperCase();
                try {
                    urlMethodMap.put(Pattern.compile(methodList[0]), Arrays.asList(methods.split(",")));
                }
                catch (PatternSyntaxException pse) {
                    // empty catch block
                }
            }
        }
        return urlMethodMap;
    }

    private boolean isEmpty(String checkString) {
        return checkString == null || checkString.trim().length() == 0;
    }
}

