/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.search;

import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class EntitySearchService<T> {
    private final String entityName;
    private final String defaultSortField;
    private final SearchMetadata.SortOrder defaultSortOrder;

    public EntitySearchService(Class<T> entityClass, String defaultSortField) {
        this(entityClass, defaultSortField, null);
    }

    public EntitySearchService(Class<T> entityClass, String defaultSortField, SearchMetadata.SortOrder defaultSortOrder) {
        this.entityName = entityClass.getName();
        this.defaultSortField = defaultSortField;
        this.defaultSortOrder = defaultSortOrder;
    }

    public SearchResult<T> getSearchResult(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters, SearchMetadata metadata) {
        List<T> entities = this.getEntityList(entityManager, alias, whereClause, parameters, metadata);
        int count = this.getEntityCount(entityManager, alias, whereClause, parameters);
        return new SearchResult(entities, count);
    }

    public List<T> getEntityList(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters, SearchMetadata metadata) {
        StringBuilder queryBuffer = new StringBuilder(this.buildSelectQueryPart(alias, false));
        if (whereClause != null) {
            queryBuffer.append(whereClause);
        }
        queryBuffer.append(this.buildSortQueryPart(alias, metadata));
        Query query = this.buildQuery(entityManager, queryBuffer.toString(), parameters);
        this.setPagingCriteria(query, metadata);
        List entityList = query.getResultList();
        return entityList;
    }

    public int getEntityCount(EntityManager entityManager, String alias, String whereClause, Map<String, Object> parameters) {
        StringBuilder queryBuffer = new StringBuilder(this.buildSelectQueryPart(alias, true));
        if (whereClause != null) {
            queryBuffer.append(whereClause);
        }
        Query countQuery = this.buildQuery(entityManager, queryBuffer.toString(), parameters);
        Long count = (Long)countQuery.getSingleResult();
        return count.intValue();
    }

    private String buildSelectQueryPart(String alias, boolean isCount) {
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (isCount) {
            queryBuf.append("COUNT(").append(alias).append(")");
        } else {
            queryBuf.append(alias);
        }
        queryBuf.append(" FROM ").append(this.entityName).append(" ").append(alias).append(" ");
        return queryBuf.toString();
    }

    private String buildSortQueryPart(String alias, SearchMetadata metadata) {
        String sortField = metadata.getSortField();
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append(" ORDER BY ");
        if (sortField != null) {
            queryBuf.append(alias).append(".").append(sortField);
            queryBuf.append(this.getSortOrder(metadata.getSortOrder()));
        }
        if (this.defaultSortField != null && !this.defaultSortField.equals(sortField)) {
            if (sortField != null) {
                queryBuf.append(", ");
            }
            queryBuf.append(alias).append(".").append(this.defaultSortField);
            queryBuf.append(this.getSortOrder(this.defaultSortOrder));
        }
        return queryBuf.toString();
    }

    private String getSortOrder(SearchMetadata.SortOrder sortOrder) {
        return sortOrder == null || sortOrder.equals((Object)SearchMetadata.SortOrder.Ascending) ? " ASC" : " DESC";
    }

    private Query buildQuery(EntityManager entityManager, String queryString, Map<String, Object> parameters) {
        Query query = entityManager.createQuery(queryString);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                query.setParameter(key, parameters.get(key));
            }
        }
        return query;
    }

    public void setPagingCriteria(Query query, SearchMetadata metadata) {
        if (metadata.getStartRecord() != null) {
            query.setFirstResult(metadata.getStartRecord().intValue());
        }
        if (metadata.getMaximumRecordCount() != null) {
            query.setMaxResults(metadata.getMaximumRecordCount().intValue());
        }
    }
}

