/**
 * This file is modified from GWT Portlets DemoPageEditor.java.
 */
/*
 * GWT Portlets Framework (http://code.google.com/p/gwtportlets/)
 * Copyright 2009 Business Systems Group (Africa)
 *
 * GWT Portlets is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GWT Portlets is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GWT Portlets.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.tandbergtv.neptune.ui.portalpage.client;

import java.util.ArrayList;
import java.util.List;

import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.edit.LayoutEditor;
import org.gwtportlets.portlet.client.edit.PageEditor;
import org.gwtportlets.portlet.client.edit.row.RowLayoutEditor;
import org.gwtportlets.portlet.client.layout.Container;
import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.layout.Layout;
import org.gwtportlets.portlet.client.layout.LayoutConstraints;
import org.gwtportlets.portlet.client.layout.RowLayout;
import org.gwtportlets.portlet.client.ui.CssButton;
import org.gwtportlets.portlet.client.ui.LayoutPanel;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.portalpage.client.ui.AddGadgetDialog;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ArrangementEditorControlDialog;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ColumnContainerEditor;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ColumnPanel;
import com.tandbergtv.neptune.ui.portalpage.client.ui.ColumnSizingLayoutPanel;
import com.tandbergtv.neptune.ui.portalpage.client.ui.Gadget;

/**
 * Our page editor.
 */
public class ArrangementEditor extends PageEditor {

    public static final int COL_LEVEL = 0;
    public static final int ROW_LEVEL = 1;

    private Container cRoot;
    private Button btnAddGadget = new CssButton("Add Portlet");
    private boolean addInProgress = false;
    private boolean gadgetsChanged = false;
    private int savedEditLevel;
    private Widget heldWidget = null;
    private PortalPage page;

    private final ArrangementEditorControlDialog status =
            new ArrangementEditorControlDialog(this);

    private AddGadgetDialog addDialog = new AddGadgetDialog(this);

    public ArrangementEditor() {
        super();
        cRoot = null;
        page = null;

        status.getLeftPanel().add(btnAddGadget);
        btnAddGadget.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<PortletConfig> availableGadgets = getNotDisplayedGadgets();
                showAddGadgetDialog(availableGadgets);
            }
        });

    }

    public void setPage(PortalPage page) {
        this.page = page;
    }

    protected void showAddGadgetDialog(List<PortletConfig> list) {
        addDialog.update(list);
    }

    public void addGadgets(List<PortletConfig> list) {
        if ((null == list) || (list.size() == 0)) {
            return;
        }
        gadgetsChanged = true;
        if (list.size() == 1) {
            // If 1 Gadget is selected, let user decide where to put it
            PortletConfig config = list.get(0);
            Gadget gadget = Gadget.createGadget(config);
            addInProgress = true;
            heldWidget = gadget;
            savedEditLevel = getEditDepth();
            setEditDepth(ROW_LEVEL);
            addWidget(gadget, true, null);
        } else {
            // If multiple Gadgets are selected, just divide them among any usable columns
            ArrayList<ColumnPanel> columnList = new ArrayList<ColumnPanel>();
            PageUtils.getUsableColumns((Widget) getRoot(), columnList);
            if (columnList.size() <= 0) {
                return;   // error, why aren't there any usable columns?
            }
            int nextColumnIndex = 0;
            for (int i=0; i<list.size(); i++) {
                PortletConfig config = list.get(i);
                Gadget gadget = Gadget.createGadget(config);
                LayoutPanel column = columnList.get(nextColumnIndex);
                column.add(gadget, gadget.getDefaultHeight());
                column.layout();
                nextColumnIndex = (nextColumnIndex+1) % columnList.size();
            }
            updateAddGadgetButton();
        }
    }

    private List<PortletConfig> getNotDisplayedGadgets() {
        List<Gadget> displayedGadgets = new ArrayList<Gadget>();
        PageUtils.getGadgets((Widget) getRoot(), displayedGadgets, null, null);
        List<PortletConfig> notDisplayedGadgets = new ArrayList<PortletConfig>();
        for (PortletConfig nextPortlet : page.getAvailablePortlets()) {
            boolean displayed = false;
            for (Gadget nextGadget : displayedGadgets) {
                if (nextGadget.getPortletId().equals(nextPortlet.getPortletId())) {
                    displayed = true;
                    break;
                }
            }
            if (!displayed) {
                notDisplayedGadgets.add(nextPortlet);
            }
        }
        return notDisplayedGadgets;
    }

    /**
     * Find the container containing the given coordinates.
     */
    private Container getContainerFor(int clientX, int clientY) {
        ArrayList<ColumnPanel> columnList = new ArrayList<ColumnPanel>();
        PageUtils.getUsableColumns((Widget) getRoot(), columnList);
        for (int i=0; i<columnList.size(); i++) {
            LayoutPanel lp = columnList.get(i);
            if (LDOM.contains(((Widget) lp).getElement(), clientX, clientY)) {
                return lp;
            }
        }
        return null;
    }

    public int getWidgetDropIndex(int clientX, int clientY, Container container) {
        int wc_ = container.getWidgetCount();
        if (((RowLayout)container.getLayout()).isColumn()) {
            for (int i = wc_ - 1; i >= 0; i--) {
                Widget w = container.getWidget(i);
                int top = w.getAbsoluteTop();
                if (clientY >= top) {
                    return clientY > (top + w.getOffsetHeight()) ? i + 1 : i;
                }
            }
        } else {
            for (int i = wc_ - 1; i >= 0; i--) {
                Widget w = container.getWidget(i);
                int left = w.getAbsoluteLeft();
                if (clientX >= left) {
                    return clientX > (left + w.getOffsetWidth()) ? i + 1 : i;
                }
            }
        }
        return 0;
    }

    public boolean dropWidgetOnContainer(Widget widget, LayoutConstraints constraints,
            String overflow, int clientX, int clientY, Container container) {
        int index = getWidgetDropIndex(clientX, clientY, container);
        if (widget.getParent() == container) {
            int ci = container.getWidgetIndex(widget);
            int wc = container.getWidgetCount();
            if ((index == ci) || ((ci == (wc - 1)) && (index == wc))) {
                return false;
            }
            if (index > (ci + 1)) {
                --index;
            }
        }
        widget.removeFromParent();
        container.insert(widget, index,
                constraints instanceof RowLayout.Constraints
                ? constraints
                        : new RowLayout.Constraints(0.0f, 1.0f, overflow));
        return true;
    }

    @Override
    public void dropWidget(int clientX, int clientY) {
        if (!addInProgress) {
            super.dropWidget(clientX, clientY);
            return;
        }

        addInProgress = false;
        Container container = getContainerFor(clientX, clientY);
        if (null != container) {
            if (dropWidgetOnContainer(heldWidget,
                    new RowLayout.Constraints(50.0f, 0.0f),
                    null, clientX, clientY, container)) {
                container.layout();
                clientX = heldWidget.getAbsoluteLeft();
                clientY = heldWidget.getAbsoluteTop();
            } else {
                discardUndo();
            }
        }
        cancelPendingUpdate();
        heldWidget = null;
        super.dropWidget(clientX, clientY);
        setEditDepth(savedEditLevel);
    }

    public void beginEditing(final String pageName, Container root) {
        endEditing(false);
        this.cRoot = root;
        gadgetsChanged = false;
        super.startEditing(pageName, root);
        status.initPopupPosition();
    }

    public void endEditing(boolean doSave) {
        if (cRoot != null) {
            if (doSave) {
                page.saveConfig();
            }
            if (getRoot() != null) {
                status.hide();
            }
            if (gadgetsChanged && (page != null)) {
                page.updateGadgetList();
            }
            super.stopEditing();
            cRoot = null;
        }
    }

    @Override
    protected void onEscPressed() {
        // Do nothing
    }

    @Override
    public void setEditDepth(int editDepth) {
        if ((ROW_LEVEL != editDepth) && (COL_LEVEL != editDepth)) {
            editDepth = COL_LEVEL;
        }
        super.setEditDepth(editDepth);
        super.getControl().hide();
        status.update();
        updateAddGadgetButton();
    }

    @Override
    protected void displayMenu(MenuBar bar, int clientX, int clientY) {
        hideMenu();
    }

    private void updateAddGadgetButton() {
        List<Gadget> displayedGadgets = new ArrayList<Gadget>();
        PageUtils.getGadgets((Widget) getRoot(), displayedGadgets, null, null);
        if ((page.getAvailablePortlets().size() == displayedGadgets.size()) || addInProgress) {
            btnAddGadget.setEnabled(false);
        } else {
            btnAddGadget.setEnabled(true);
        }
    }

    @SuppressWarnings("rawtypes")
    @Override
    protected void savePage(WidgetFactory wf, AsyncCallback callback) {
        // We don't have a save page button, we save automatically when user exits
    }

    /**
     * Create an editor for container or return null if none is available
     * (i.e. unsupported layout).
     */
    @Override
    protected LayoutEditor createEditorFor(Container c) {
        Layout layout = c.getLayout();
        if (layout instanceof RowLayout) {
            if (c instanceof ColumnSizingLayoutPanel) {
                return new ColumnContainerEditor();
            }
            return new RowLayoutEditor();
        }
        return null;
    }

}
