/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NamingUtil {
    private static Logger logger = Logger.getLogger(NamingUtil.class);

    public static String getDC(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return "";
        }
        ArrayList<String> l = new ArrayList<String>(10);
        for (String dc : domain.split("\\.")) {
            l.add("DC=" + dc);
        }
        return StringUtils.join(l, (char)',');
    }

    public static String getUserDN(String pattern, String domain, Object ... args) {
        if (StringUtils.isBlank((String)pattern)) {
            return "";
        }
        return MessageFormat.format(pattern + "," + NamingUtil.getDC(domain), args);
    }

    public static List<String> getRoles(List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> roles = new ArrayList<String>(values.size());
        for (String value : values) {
            String role = NamingUtil.getRole(value);
            if (!StringUtils.isNotBlank((String)role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static String getRole(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        String[] parts = value.split(",")[0].split("=");
        if (parts.length != 2) {
            logger.debug((Object)("invalid DN: " + value));
            return "";
        }
        return parts[1].trim();
    }
}

