/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.sync;

import com.ericsson.neptune.usermgmt.ad.IAdUserManager;
import com.ericsson.neptune.usermgmt.ad.model.ADUser;
import com.ericsson.neptune.usermgmt.ad.model.UserConverter;
import com.ericsson.neptune.usermgmt.sync.IUserSynchronizer;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.UserSynchronizationException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LDAPUserSychronzier
implements IUserSynchronizer {
    private IAdUserManager adUserManager;
    private IUserManager userManager;
    private UserConverter userConverter;

    @Override
    public void syncUser(String userId, String credentials) {
        this.syncUser(userId, credentials, Collections.emptyMap());
    }

    @Override
    public void syncUser(String userId, String credentials, Map<String, Object> params) {
        this.doSyncUser(userId, credentials);
    }

    @Override
    public void simpleSyncUser(String userId) throws UserSynchronizationException {
        this.doSyncUser(userId, null);
    }

    private void doSyncUser(String userId, String password) {
        if (StringUtils.isBlank((String)userId)) {
            throw new UserSynchronizationException("user ID cannot be null");
        }
        try {
            ADUser user;
            ADUser aDUser = user = StringUtils.isBlank((String)password) ? this.adUserManager.getUser(userId) : this.adUserManager.getUser(userId, password);
            if (user == null || StringUtils.isBlank((String)user.getUserName())) {
                throw new Exception("Cannot find user[" + userId + "] from LDAP");
            }
            User dbUser = this.userManager.getUser(userId);
            if (dbUser == null) {
                this.createUser(user);
            } else {
                this.updateUser(user, dbUser.getId());
            }
        }
        catch (Exception e) {
            throw new UserSynchronizationException(e);
        }
    }

    private void createUser(ADUser user) throws Exception {
        User u = this.userConverter.toCMSUser(user);
        if (u == null) {
            throw new Exception("Cannot create user");
        }
        u.setExternallyAuthenticated(true);
        this.userManager.createExternalUser(u);
    }

    private void updateUser(ADUser user, Long id) throws Exception {
        User u = this.userConverter.toCMSUser(user);
        if (u == null) {
            throw new Exception("Cannot update user");
        }
        u.setId(id);
        u.setExternallyAuthenticated(true);
        this.userManager.updateExternalUser(u);
    }

    public void setAdUserManager(IAdUserManager adUserManager) {
        this.adUserManager = adUserManager;
    }

    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    public void setUserConverter(UserConverter userConverter) {
        this.userConverter = userConverter;
    }
}

