/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.alerts.rest.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class RestClient {
    int connTimeout = 2000;
    int readTimeout = 4000;
    private static final Logger logger = Logger.getLogger(RestClient.class);

    public RestClient(int readTimeout, int connTimeout) {
        this.readTimeout = readTimeout;
        this.connTimeout = connTimeout;
    }

    @Deprecated
    public String getJsonAlerts(String url) {
        try {
            return this.getAlerts(url);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)(url + " connection timed-out:" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "";
    }

    public String getAlerts(String url) throws SocketTimeoutException, Exception {
        HttpURLConnection conn = null;
        try {
            this.disableSSL();
            URL urlComponent = new URL(url);
            conn = (HttpURLConnection)urlComponent.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(this.connTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                String string = builder.toString();
                return string;
            }
            logger.error((Object)(url + " connection failed: HTTP error code : " + conn.getResponseCode() + " response message:" + conn.getResponseMessage()));
            throw new Exception("HTTP call failure, status: " + conn.getResponseCode());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void disableSSL() throws NoSuchAlgorithmException, KeyManagementException {
        javax.net.ssl.TrustManager[] trustAllCerts = new TrustManager[]{new TrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private class TrustManager
    implements X509TrustManager {
        private TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

