package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.HashMap;

import com.tandbergtv.neptune.ui.realm.client.settings.service.UiBooleanSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiEnumerationSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiFloatSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiIntegerSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiPasswordSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiStringSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiTextSetting;

public class SettingsWidgetFactory {

    private static HashMap<Class<?>, SettingsInputWidgetWrapper> wrappers;
    static {
        wrappers = new HashMap<Class<?>, SettingsInputWidgetWrapper>();
        wrappers.put(UiStringSetting.class, new StringInputWidgetWrapper());
        wrappers.put(UiBooleanSetting.class, new BooleanInputWidgetWrapper());
        wrappers.put(UiEnumerationSetting.class, new EnumerationInputWidgetWrapper());
        wrappers.put(UiIntegerSetting.class, new IntegerInputWidgetWrapper());
        wrappers.put(UiFloatSetting.class, new FloatInputWidgetWrapper());
        wrappers.put(UiTextSetting.class, new TextInputWidgetWrapper());
        wrappers.put(UiPasswordSetting.class, new PasswordInputWidgetWrapper());
    }

    public static SettingsInputWidgetWrapper getWidgetFor(UiSettingDefinition def, String initialValue) {
        SettingsInputWidgetWrapper widgetWrapperClass = wrappers.get(def.getClass()).newInstance();
        widgetWrapperClass.setSettingDefinition(def);
        widgetWrapperClass.setInitialValue(initialValue);

        return widgetWrapperClass;
    }
}
