/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.user.view.external;

import com.google.gwt.event.shared.EventHandler;

/**
 * Handler for the event fired by the external user view
 * 
 * @author Vijay Silva
 */
public interface ExternalUserViewEventHandler extends EventHandler {

	/**
	 * The view is showing a blank widget / screen
	 * 
	 * @param event The event
	 */
	void onShowBlankWidget(ExternalUserViewEvent event);

	/**
	 * The view is showing the external user table
	 * 
	 * @param event The event
	 */
	void onShowTable(ExternalUserViewEvent event);

	/**
	 * The view is showing the external user record
	 * 
	 * @param event The event
	 */
	void onShowExternalUser(ExternalUserViewEvent event);
}
