package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.FeatureEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * <p>
 * This interface provides all the methods necessary to add features to the table. This interface
 * exposes internal state of the table and is only meant to be used by table features.
 * </p>
 * <p>
 * TODO refactor the relationship between the table and features to improve encapsulation.
 * </p>
 * 
 * @param <R> record type being used
 */
public class InternalTable<K, R extends Record<K>> {

	/* The table */
	private final Table<K, R> table;

	/**
	 * Constructor
	 * 
	 * @param table The table
	 */
	public InternalTable(Table<K, R> table) {
		this.table = table;
	}

	/**
	 * @return the table
	 */
	public Table<K, R> getTable() {
		return table;
	}

	/**
	 * @see Table#showView(Widget, String)
	 */
	public void showView(Widget view, String viewName) {
		table.showView(view, viewName);
	}

	/**
	 * @see Table#isShowingView(Widget)
	 */
	public boolean isShowingView(Widget view) {
		return table.isShowingView(view);
	}

	/**
	 * @see Table#showListView()
	 */
	public void showListView() {
		table.showListView();
	}

	/**
	 * @see Table#isShowingListView()
	 */
	public boolean isShowingListView() {
		return table.isShowingListView();
	}

	/**
	 * @see Table#showCreateView()
	 */
	public void showCreateView() {
		table.showCreateView();
	}

	/**
	 * @see Table#showDetailView(Record)
	 */
	public void showDetailView(R record) {
		table.showDetailView(record);
	}

	/**
	 * @see Table#getColumns()
	 */
	public List<Column<?, R>> getColumns() {
		return table.getColumns();
	}

	/**
	 * @see Table#getWidgetsForColumn(Column)
	 */
	public List<Widget> getWidgetsForColumn(Column<?, R> column) {
		return table.getWidgetsForColumn(column);
	}

	/**
	 * @see Table#getRecordForWidget(Widget)
	 */
	public R getRecordForWidget(Widget widget) {
		return table.getRecordForWidget(widget);
	}

	/**
	 * @see Table#getRecordForKey(Object, AsyncCallback)
	 */
	public void getRecordForKey(K key, AsyncCallback<R> callback) {
		table.getRecordForKey(key, callback);
	}

	/**
	 * @see Table#getHeaderWidgetForColumn(Column)
	 */
	public HorizontalPanel getHeaderWidgetForColumn(Column<?, R> column) {
		return table.getHeaderWidgetForColumn(column);
	}

	/**
	 * @see Table#getHeaderWidgetLabelForColumn(Column)
	 */
	public Label getHeaderWidgetLabelForColumn(Column<?, R> column) {
		return table.getHeaderWidgetLabelForColumn(column);
	}

	/**
	 * @see Table#getPaginationPanel()
	 */
	public SimpleContainer getPaginationPanel() {
		return table.getPaginationPanel();
	}

	/**
	 * @see Table#setTotalRecordCount()
	 */
	public void setTotalRecordCount(Integer recordCount) {
		table.setTotalRecordCount(recordCount);
	}

	/**
	 * @see Table#handleFeatureEvent(FeatureEvent)
	 */
	public void handleFeatureEvent(FeatureEvent featureEvent) {
		table.handleFeatureEvent(featureEvent);
	}

	/**
	 * @see Table#fireDetailViewEvent(TableDetailViewEvent)
	 */
	public void fireDetailViewEvent(TableDetailViewEvent<K, R> event) {
		table.fireDetailViewEvent(event);
	}
}
