/*
 * Created on Sep 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * The call back registered with the view that provides notification for the view events
 */
public interface DetailViewCallback<K, R extends Record<K>> {

	/**
	 * Provides notification when the save action must be performed on the detail view
	 * 
	 * @param view The detail view
	 */
	public void save(DetailView<K, R> view);

	/**
	 * Provides notification when the revert action must be performed on the detail view
	 * 
	 * @param view The detail view
	 */
	public void revert(DetailView<K, R> view);

	/**
	 * Provides notification when the cancel action must be performed on the detail view
	 * 
	 * @param view The detail view
	 */
	public void cancel(DetailView<K, R> view);
}
