/*
 * Created on May 17, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link FileUpload} widget.
 * 
 * @see com.google.gwt.user.client.ui.FileUpload
 * @author Vijay Silva
 */
public class FileUploadWidget extends FileUpload implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FileUpload#FileUpload()
	 */
	public FileUploadWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.FileUpload#FileUpload(Element)
	 */
	protected FileUploadWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.FileUpload#wrap(Element)
	 */
	public static FileUploadWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		FileUploadWidget widget = new FileUploadWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
