package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Panel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.ExpandingFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.ExpandingFeatureImages;

/**
 * The button to represent the expand/collapse action
 * 
 * @author Daniel Silva
 */
public class ExpandCollapseButton<K, R extends Record<K>> extends ImageWidget {
	
	private R record;
	
	private Panel expandedPanel;
	
	private ExpandingFeature<K,R> expandingFeature;
	
	private final ExpandingFeatureImages bundle;
	
	private ImageResource expandImage;
	
	private ImageResource collapseImage;	
	
	/**
	 * Constructor
	 * 
	 * @param expandedPanel The expanded panel
	 * @param expandingFeature The expanding feature
	 */
	public ExpandCollapseButton( Panel expandedPanel, ExpandingFeature<K,R> expandingFeature ) {
		this( expandedPanel, expandingFeature, null, null );
	}
	
	/**
	 * Constructor
	 * 
	 * @param expandedPanel The expanded panel
	 * @param expandingFeature The expanding feature
	 * @param expandImage The expand image
	 * @param collapseImage The collapse image
	 */
	public ExpandCollapseButton( Panel expandedPanel, ExpandingFeature<K,R> expandingFeature, ImageResource expandImage, ImageResource collapseImage ) {
		this.expandedPanel = expandedPanel;
		this.setExpandingFeature(expandingFeature);
		bundle = GWT.create(ExpandingFeatureImages.class);
		if ( expandImage != null ) {
			this.expandImage = expandImage;
		} else {
			this.expandImage = bundle.expand();
		}
		if ( collapseImage != null ) {
			this.collapseImage = collapseImage;
		} else {
			this.collapseImage = bundle.collapse();
		}
		this.setResource( this.expandImage );
		this.setStyleName( TableConstants.STYLE_HEADER_SORTABLE_COL_TEXT );
	}

	/**
	 * Get the record
	 * 
	 * @return the record
	 */
	public R getRecord() {
		return record;
	}


	/**
	 * Set the record
	 * 
	 * @param record
	 */
	public void setRecord(R record) {
		this.record = record;
	}

	/**
	 * Set the expanded panel
	 * 
	 * @param expandedPanel
	 */
	public void setExpandedPanel(Panel expandedPanel) {
		this.expandedPanel = expandedPanel;
	}

	/**
	 * Get the expanded panel
	 * 
	 * @return The expanded panel
	 */
	public Panel getExpandedPanel() {
		return expandedPanel;
	}
	
	/**
	 * Set the expand image
	 * 
	 * @param expandImage The expand image
	 */
	public void setExpandImage( ImageResource expandImage ) {
		this.expandImage = expandImage;
	}
	
	/**
	 * Set the collapse image
	 * 
	 * @param collapseImage The collapse image
	 */
	public void setCollapseImage( ImageResource collapseImage ) {
		this.collapseImage = collapseImage;
	}

	/**
	 * Set the expanding feature
	 * 
	 * @param expandingFeature The expanding feature
	 */
	public void setExpandingFeature(ExpandingFeature<K,R> expandingFeature) {
		this.expandingFeature = expandingFeature;
	}

	/**
	 * Get the expanding feature
	 * 
	 * @return The expanding feature
	 */
	public ExpandingFeature<K,R> getExpandingFeature() {
		return expandingFeature;
	}
	
	/**
	 * Changes the button state between expanded and collaped
	 */
	public void changeState() {
		if ( expandedPanel != null ) {
			expandedPanel.setVisible( !expandedPanel.isVisible() );
			if ( expandedPanel.isVisible() ) {				
				expandedPanel.add( expandingFeature.getExpandingProvider().getWidget( record ) );
				this.setResource( collapseImage );
			} else {
				expandedPanel.clear();
				this.setResource( expandImage );
			}			
		}		
	}	
}
