package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.LazyContainer;

/**
 * A Frame widget that is a lazy view
 * 
 * @author mpetrusis
 */
public class AutosizeFrame extends LazyContainer {

	private Frame widget = null;
	
	private HandlerRegistration resizeHandlerRegistration;
	

	public AutosizeFrame() {
	}

	public void setUrl(String url) {
		
		this.ensureWidget();
		this.widget.setUrl (url);
	}

	@Override
	protected Widget createWidget() {
		this.widget = new FrameWidget(){
			public void onBrowserEvent(Event event) {
			    super.onBrowserEvent(event);
			    NeptuneApplication.getApplication().hideMenu();
			  }
			};
		widget.sinkEvents(Event.ONMOUSEOVER);
		widget.getElement().setAttribute("frameBorder", "0");
		widget.setStyleName("autosizeframe");
		updateIframeHeight();
		return this.widget;
	}
	
	
	private void updateIframeHeight() {
		int height = Window.getClientHeight() - NeptuneApplication.CMS_HEADER_HEIGHT_PX;
		widget.setHeight(height + "px");
	}
	
	@Override
	protected void onLoad() {
		
		super.onLoad();
		resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateIframeHeight();
			}
		});
	};

	@Override
	protected void onUnload() {
		resizeHandlerRegistration.removeHandler();
		resizeHandlerRegistration = null;
		super.onUnload();
	}
}
